/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.agent.CheckDefinition;
import com.orbitz.consul.model.agent.CheckV2;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="CheckV2", generator="Immutables")
@Immutable
public final class ImmutableCheckV2
extends CheckV2 {
    @Nullable
    private final String node;
    @Nullable
    private final String id;
    @Nullable
    private final String name;
    @Nullable
    private final String notes;
    @Nullable
    private final String status;
    @Nullable
    private final String serviceId;
    @Nullable
    private final String namespace;
    @Nullable
    private final CheckDefinition definition;

    private ImmutableCheckV2(@Nullable String node, @Nullable String id, @Nullable String name, @Nullable String notes, @Nullable String status, @Nullable String serviceId, @Nullable String namespace, @Nullable CheckDefinition definition) {
        this.node = node;
        this.id = id;
        this.name = name;
        this.notes = notes;
        this.status = status;
        this.serviceId = serviceId;
        this.namespace = namespace;
        this.definition = definition;
    }

    @Override
    @JsonProperty(value="Node")
    public Optional<String> getNode() {
        return Optional.ofNullable(this.node);
    }

    @Override
    @JsonProperty(value="CheckId")
    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Name")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="Notes")
    public Optional<String> getNotes() {
        return Optional.ofNullable(this.notes);
    }

    @Override
    @JsonProperty(value="Status")
    public Optional<String> getStatus() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="ServiceID")
    public Optional<String> getServiceId() {
        return Optional.ofNullable(this.serviceId);
    }

    @Override
    @JsonProperty(value="Namespace")
    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    @Override
    @JsonProperty(value="Definition")
    public Optional<CheckDefinition> getDefinition() {
        return Optional.ofNullable(this.definition);
    }

    public final ImmutableCheckV2 withNode(String value) {
        String newValue = Objects.requireNonNull(value, "node");
        if (Objects.equals(this.node, newValue)) {
            return this;
        }
        return new ImmutableCheckV2(newValue, this.id, this.name, this.notes, this.status, this.serviceId, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.node, value)) {
            return this;
        }
        return new ImmutableCheckV2(value, this.id, this.name, this.notes, this.status, this.serviceId, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, newValue, this.name, this.notes, this.status, this.serviceId, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, value, this.name, this.notes, this.status, this.serviceId, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, newValue, this.notes, this.status, this.serviceId, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, value, this.notes, this.status, this.serviceId, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withNotes(String value) {
        String newValue = Objects.requireNonNull(value, "notes");
        if (Objects.equals(this.notes, newValue)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, this.name, newValue, this.status, this.serviceId, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withNotes(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.notes, value)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, this.name, value, this.status, this.serviceId, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, this.name, this.notes, newValue, this.serviceId, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, this.name, this.notes, value, this.serviceId, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withServiceId(String value) {
        String newValue = Objects.requireNonNull(value, "serviceId");
        if (Objects.equals(this.serviceId, newValue)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, this.name, this.notes, this.status, newValue, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withServiceId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceId, value)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, this.name, this.notes, this.status, value, this.namespace, this.definition);
    }

    public final ImmutableCheckV2 withNamespace(String value) {
        String newValue = Objects.requireNonNull(value, "namespace");
        if (Objects.equals(this.namespace, newValue)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, this.name, this.notes, this.status, this.serviceId, newValue, this.definition);
    }

    public final ImmutableCheckV2 withNamespace(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.namespace, value)) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, this.name, this.notes, this.status, this.serviceId, value, this.definition);
    }

    public final ImmutableCheckV2 withDefinition(CheckDefinition value) {
        CheckDefinition newValue = Objects.requireNonNull(value, "definition");
        if (this.definition == newValue) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, this.name, this.notes, this.status, this.serviceId, this.namespace, newValue);
    }

    public final ImmutableCheckV2 withDefinition(Optional<? extends CheckDefinition> optional) {
        CheckDefinition value = optional.orElse(null);
        if (this.definition == value) {
            return this;
        }
        return new ImmutableCheckV2(this.node, this.id, this.name, this.notes, this.status, this.serviceId, this.namespace, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckV2 && this.equalTo((ImmutableCheckV2)another);
    }

    private boolean equalTo(ImmutableCheckV2 another) {
        return Objects.equals(this.node, another.node) && Objects.equals(this.id, another.id) && Objects.equals(this.name, another.name) && Objects.equals(this.notes, another.notes) && Objects.equals(this.status, another.status) && Objects.equals(this.serviceId, another.serviceId) && Objects.equals(this.namespace, another.namespace) && Objects.equals(this.definition, another.definition);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.node);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.notes);
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Objects.hashCode(this.serviceId);
        h += (h << 5) + Objects.hashCode(this.namespace);
        h += (h << 5) + Objects.hashCode(this.definition);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CheckV2").omitNullValues().add("node", (Object)this.node).add("id", (Object)this.id).add("name", (Object)this.name).add("notes", (Object)this.notes).add("status", (Object)this.status).add("serviceId", (Object)this.serviceId).add("namespace", (Object)this.namespace).add("definition", (Object)this.definition).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckV2 fromJson(Json json) {
        Builder builder = ImmutableCheckV2.builder();
        if (json.node != null) {
            builder.setNode(json.node);
        }
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.notes != null) {
            builder.setNotes(json.notes);
        }
        if (json.status != null) {
            builder.setStatus(json.status);
        }
        if (json.serviceId != null) {
            builder.setServiceId(json.serviceId);
        }
        if (json.namespace != null) {
            builder.setNamespace(json.namespace);
        }
        if (json.definition != null) {
            builder.setDefinition(json.definition);
        }
        return builder.build();
    }

    public static ImmutableCheckV2 copyOf(CheckV2 instance) {
        if (instance instanceof ImmutableCheckV2) {
            return (ImmutableCheckV2)instance;
        }
        return ImmutableCheckV2.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CheckV2", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String node;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String notes;
        @Nullable
        private String status;
        @Nullable
        private String serviceId;
        @Nullable
        private String namespace;
        @Nullable
        private CheckDefinition definition;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckV2 instance) {
            Optional<CheckDefinition> definitionOptional;
            Optional<String> namespaceOptional;
            Optional<String> serviceIdOptional;
            Optional<String> statusOptional;
            Optional<String> notesOptional;
            Optional<String> nameOptional;
            Optional<String> idOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> nodeOptional = instance.getNode();
            if (nodeOptional.isPresent()) {
                this.setNode(nodeOptional);
            }
            if ((idOptional = instance.getId()).isPresent()) {
                this.setId(idOptional);
            }
            if ((nameOptional = instance.getName()).isPresent()) {
                this.setName(nameOptional);
            }
            if ((notesOptional = instance.getNotes()).isPresent()) {
                this.setNotes(notesOptional);
            }
            if ((statusOptional = instance.getStatus()).isPresent()) {
                this.setStatus(statusOptional);
            }
            if ((serviceIdOptional = instance.getServiceId()).isPresent()) {
                this.setServiceId(serviceIdOptional);
            }
            if ((namespaceOptional = instance.getNamespace()).isPresent()) {
                this.setNamespace(namespaceOptional);
            }
            if ((definitionOptional = instance.getDefinition()).isPresent()) {
                this.setDefinition(definitionOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setNode(String node) {
            this.node = Objects.requireNonNull(node, "node");
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder setNode(Optional<String> node) {
            this.node = node.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="CheckId")
        @CanIgnoreReturnValue
        public final Builder setId(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder setName(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setNotes(String notes) {
            this.notes = Objects.requireNonNull(notes, "notes");
            return this;
        }

        @JsonProperty(value="Notes")
        @CanIgnoreReturnValue
        public final Builder setNotes(Optional<String> notes) {
            this.notes = notes.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setStatus(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="Status")
        @CanIgnoreReturnValue
        public final Builder setStatus(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setServiceId(String serviceId) {
            this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
            return this;
        }

        @JsonProperty(value="ServiceID")
        @CanIgnoreReturnValue
        public final Builder setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setNamespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            return this;
        }

        @JsonProperty(value="Namespace")
        @CanIgnoreReturnValue
        public final Builder setNamespace(Optional<String> namespace) {
            this.namespace = namespace.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setDefinition(CheckDefinition definition) {
            this.definition = Objects.requireNonNull(definition, "definition");
            return this;
        }

        @JsonProperty(value="Definition")
        @CanIgnoreReturnValue
        public final Builder setDefinition(Optional<? extends CheckDefinition> definition) {
            this.definition = definition.orElse(null);
            return this;
        }

        public ImmutableCheckV2 build() {
            return new ImmutableCheckV2(this.node, this.id, this.name, this.notes, this.status, this.serviceId, this.namespace, this.definition);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckV2", generator="Immutables")
    static final class Json
    extends CheckV2 {
        @Nullable
        Optional<String> node = Optional.empty();
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        Optional<String> name = Optional.empty();
        @Nullable
        Optional<String> notes = Optional.empty();
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        Optional<String> serviceId = Optional.empty();
        @Nullable
        Optional<String> namespace = Optional.empty();
        @Nullable
        Optional<CheckDefinition> definition = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(Optional<String> node) {
            this.node = node;
        }

        @JsonProperty(value="CheckId")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="Notes")
        public void setNotes(Optional<String> notes) {
            this.notes = notes;
        }

        @JsonProperty(value="Status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="Namespace")
        public void setNamespace(Optional<String> namespace) {
            this.namespace = namespace;
        }

        @JsonProperty(value="Definition")
        public void setDefinition(Optional<CheckDefinition> definition) {
            this.definition = definition;
        }

        @Override
        public Optional<String> getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNotes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNamespace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CheckDefinition> getDefinition() {
            throw new UnsupportedOperationException();
        }
    }
}

