/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.agent.Config;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Config", generator="Immutables")
@Immutable
public final class ImmutableConfig
extends Config {
    private final String datacenter;
    private final String nodeName;
    private final String revision;
    private final boolean server;
    private final String version;

    private ImmutableConfig(String datacenter, String nodeName, String revision, boolean server, String version) {
        this.datacenter = datacenter;
        this.nodeName = nodeName;
        this.revision = revision;
        this.server = server;
        this.version = version;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public String getDatacenter() {
        return this.datacenter;
    }

    @Override
    @JsonProperty(value="NodeName")
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    @JsonProperty(value="Revision")
    public String getRevision() {
        return this.revision;
    }

    @Override
    @JsonProperty(value="Server")
    public boolean getServer() {
        return this.server;
    }

    @Override
    @JsonProperty(value="Version")
    public String getVersion() {
        return this.version;
    }

    public final ImmutableConfig withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (this.datacenter.equals(newValue)) {
            return this;
        }
        return new ImmutableConfig(newValue, this.nodeName, this.revision, this.server, this.version);
    }

    public final ImmutableConfig withNodeName(String value) {
        String newValue = Objects.requireNonNull(value, "nodeName");
        if (this.nodeName.equals(newValue)) {
            return this;
        }
        return new ImmutableConfig(this.datacenter, newValue, this.revision, this.server, this.version);
    }

    public final ImmutableConfig withRevision(String value) {
        String newValue = Objects.requireNonNull(value, "revision");
        if (this.revision.equals(newValue)) {
            return this;
        }
        return new ImmutableConfig(this.datacenter, this.nodeName, newValue, this.server, this.version);
    }

    public final ImmutableConfig withServer(boolean value) {
        if (this.server == value) {
            return this;
        }
        return new ImmutableConfig(this.datacenter, this.nodeName, this.revision, value, this.version);
    }

    public final ImmutableConfig withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableConfig(this.datacenter, this.nodeName, this.revision, this.server, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfig && this.equalTo((ImmutableConfig)another);
    }

    private boolean equalTo(ImmutableConfig another) {
        return this.datacenter.equals(another.datacenter) && this.nodeName.equals(another.nodeName) && this.revision.equals(another.revision) && this.server == another.server && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.datacenter.hashCode();
        h += (h << 5) + this.nodeName.hashCode();
        h += (h << 5) + this.revision.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.server);
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Config").omitNullValues().add("datacenter", (Object)this.datacenter).add("nodeName", (Object)this.nodeName).add("revision", (Object)this.revision).add("server", this.server).add("version", (Object)this.version).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableConfig fromJson(Json json) {
        Builder builder = ImmutableConfig.builder();
        if (json.datacenter != null) {
            builder.setDatacenter(json.datacenter);
        }
        if (json.nodeName != null) {
            builder.setNodeName(json.nodeName);
        }
        if (json.revision != null) {
            builder.setRevision(json.revision);
        }
        if (json.serverIsSet) {
            builder.setServer(json.server);
        }
        if (json.version != null) {
            builder.setVersion(json.version);
        }
        return builder.build();
    }

    public static ImmutableConfig copyOf(Config instance) {
        if (instance instanceof ImmutableConfig) {
            return (ImmutableConfig)instance;
        }
        return ImmutableConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Config", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATACENTER = 1L;
        private static final long INIT_BIT_NODE_NAME = 2L;
        private static final long INIT_BIT_REVISION = 4L;
        private static final long INIT_BIT_SERVER = 8L;
        private static final long INIT_BIT_VERSION = 16L;
        private long initBits = 31L;
        @Nullable
        private String datacenter;
        @Nullable
        private String nodeName;
        @Nullable
        private String revision;
        private boolean server;
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Config instance) {
            Objects.requireNonNull(instance, "instance");
            this.setDatacenter(instance.getDatacenter());
            this.setNodeName(instance.getNodeName());
            this.setRevision(instance.getRevision());
            this.setServer(instance.getServer());
            this.setVersion(instance.getVersion());
            return this;
        }

        @JsonProperty(value="Datacenter")
        @CanIgnoreReturnValue
        public final Builder setDatacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="NodeName")
        @CanIgnoreReturnValue
        public final Builder setNodeName(String nodeName) {
            this.nodeName = Objects.requireNonNull(nodeName, "nodeName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Revision")
        @CanIgnoreReturnValue
        public final Builder setRevision(String revision) {
            this.revision = Objects.requireNonNull(revision, "revision");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Server")
        @CanIgnoreReturnValue
        public final Builder setServer(boolean server) {
            this.server = server;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Version")
        @CanIgnoreReturnValue
        public final Builder setVersion(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfig(this.datacenter, this.nodeName, this.revision, this.server, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("datacenter");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nodeName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("revision");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("server");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build Config, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Config", generator="Immutables")
    static final class Json
    extends Config {
        @Nullable
        String datacenter;
        @Nullable
        String nodeName;
        @Nullable
        String revision;
        boolean server;
        boolean serverIsSet;
        @Nullable
        String version;

        Json() {
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(String datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="NodeName")
        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @JsonProperty(value="Revision")
        public void setRevision(String revision) {
            this.revision = revision;
        }

        @JsonProperty(value="Server")
        public void setServer(boolean server) {
            this.server = server;
            this.serverIsSet = true;
        }

        @JsonProperty(value="Version")
        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        public String getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNodeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRevision() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getServer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

