/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.agent.Registration;
import com.orbitz.consul.model.catalog.ServiceWeights;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Registration", generator="Immutables")
@Immutable
public final class ImmutableRegistration
extends Registration {
    private final String name;
    private final String id;
    @Nullable
    private final String address;
    @Nullable
    private final Integer port;
    @Nullable
    private final Registration.RegCheck check;
    private final ImmutableList<Registration.RegCheck> checks;
    private final ImmutableList<String> tags;
    private final ImmutableMap<String, String> meta;
    @Nullable
    private final Boolean enableTagOverride;
    @Nullable
    private final ServiceWeights serviceWeights;

    private ImmutableRegistration(String name, String id, @Nullable String address, @Nullable Integer port, @Nullable Registration.RegCheck check, ImmutableList<Registration.RegCheck> checks, ImmutableList<String> tags, ImmutableMap<String, String> meta, @Nullable Boolean enableTagOverride, @Nullable ServiceWeights serviceWeights) {
        this.name = name;
        this.id = id;
        this.address = address;
        this.port = port;
        this.check = check;
        this.checks = checks;
        this.tags = tags;
        this.meta = meta;
        this.enableTagOverride = enableTagOverride;
        this.serviceWeights = serviceWeights;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Address")
    public Optional<String> getAddress() {
        return Optional.ofNullable(this.address);
    }

    @Override
    @JsonProperty(value="Port")
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    @Override
    @JsonProperty(value="Check")
    public Optional<Registration.RegCheck> getCheck() {
        return Optional.ofNullable(this.check);
    }

    @JsonProperty(value="Checks")
    public ImmutableList<Registration.RegCheck> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="Tags")
    public ImmutableList<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="Meta")
    public ImmutableMap<String, String> getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty(value="EnableTagOverride")
    public Optional<Boolean> getEnableTagOverride() {
        return Optional.ofNullable(this.enableTagOverride);
    }

    @Override
    @JsonProperty(value="Weights")
    public Optional<ServiceWeights> getServiceWeights() {
        return Optional.ofNullable(this.serviceWeights);
    }

    public final ImmutableRegistration withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRegistration(newValue, this.id, this.address, this.port, this.check, this.checks, this.tags, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableRegistration(this.name, newValue, this.address, this.port, this.check, this.checks, this.tags, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (Objects.equals(this.address, newValue)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, newValue, this.port, this.check, this.checks, this.tags, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withAddress(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.address, value)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, value, this.port, this.check, this.checks, this.tags, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withPort(int value) {
        Integer newValue = value;
        if (Objects.equals(this.port, newValue)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, newValue, this.check, this.checks, this.tags, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withPort(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.port, value)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, value, this.check, this.checks, this.tags, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withCheck(Registration.RegCheck value) {
        Registration.RegCheck newValue = Objects.requireNonNull(value, "check");
        if (this.check == newValue) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, newValue, this.checks, this.tags, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withCheck(Optional<? extends Registration.RegCheck> optional) {
        Registration.RegCheck value = optional.orElse(null);
        if (this.check == value) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, value, this.checks, this.tags, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withChecks(Registration.RegCheck ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, (ImmutableList<Registration.RegCheck>)newValue, this.tags, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withChecks(Iterable<? extends Registration.RegCheck> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, (ImmutableList<Registration.RegCheck>)newValue, this.tags, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, (ImmutableList<String>)newValue, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, (ImmutableList<String>)newValue, this.meta, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withMeta(Map<String, ? extends String> entries) {
        if (this.meta == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, this.tags, (ImmutableMap<String, String>)newValue, this.enableTagOverride, this.serviceWeights);
    }

    public final ImmutableRegistration withEnableTagOverride(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableTagOverride, newValue)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, this.tags, this.meta, newValue, this.serviceWeights);
    }

    public final ImmutableRegistration withEnableTagOverride(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableTagOverride, value)) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, this.tags, this.meta, value, this.serviceWeights);
    }

    public final ImmutableRegistration withServiceWeights(ServiceWeights value) {
        ServiceWeights newValue = Objects.requireNonNull(value, "serviceWeights");
        if (this.serviceWeights == newValue) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, this.tags, this.meta, this.enableTagOverride, newValue);
    }

    public final ImmutableRegistration withServiceWeights(Optional<? extends ServiceWeights> optional) {
        ServiceWeights value = optional.orElse(null);
        if (this.serviceWeights == value) {
            return this;
        }
        return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks, this.tags, this.meta, this.enableTagOverride, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegistration && this.equalTo((ImmutableRegistration)another);
    }

    private boolean equalTo(ImmutableRegistration another) {
        return this.name.equals(another.name) && this.id.equals(another.id) && Objects.equals(this.address, another.address) && Objects.equals(this.port, another.port) && Objects.equals(this.check, another.check) && this.checks.equals(another.checks) && this.tags.equals(another.tags) && this.meta.equals(another.meta) && Objects.equals(this.enableTagOverride, another.enableTagOverride) && Objects.equals(this.serviceWeights, another.serviceWeights);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.address);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode(this.check);
        h += (h << 5) + this.checks.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.meta.hashCode();
        h += (h << 5) + Objects.hashCode(this.enableTagOverride);
        h += (h << 5) + Objects.hashCode(this.serviceWeights);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Registration").omitNullValues().add("name", (Object)this.name).add("id", (Object)this.id).add("address", (Object)this.address).add("port", (Object)this.port).add("check", (Object)this.check).add("checks", this.checks).add("tags", this.tags).add("meta", this.meta).add("enableTagOverride", (Object)this.enableTagOverride).add("serviceWeights", (Object)this.serviceWeights).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRegistration fromJson(Json json) {
        Builder builder = ImmutableRegistration.builder();
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.address != null) {
            builder.setAddress(json.address);
        }
        if (json.port != null) {
            builder.setPort(json.port);
        }
        if (json.check != null) {
            builder.setCheck(json.check);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.meta != null) {
            builder.putAllMeta(json.meta);
        }
        if (json.enableTagOverride != null) {
            builder.setEnableTagOverride(json.enableTagOverride);
        }
        if (json.serviceWeights != null) {
            builder.setServiceWeights(json.serviceWeights);
        }
        return builder.build();
    }

    public static ImmutableRegistration copyOf(Registration instance) {
        if (instance instanceof ImmutableRegistration) {
            return (ImmutableRegistration)instance;
        }
        return ImmutableRegistration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Registration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String id;
        @Nullable
        private String address;
        @Nullable
        private Integer port;
        @Nullable
        private Registration.RegCheck check;
        private ImmutableList.Builder<Registration.RegCheck> checks = ImmutableList.builder();
        private ImmutableList.Builder<String> tags = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> meta = ImmutableMap.builder();
        @Nullable
        private Boolean enableTagOverride;
        @Nullable
        private ServiceWeights serviceWeights;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Registration instance) {
            Optional<ServiceWeights> serviceWeightsOptional;
            Optional<Registration.RegCheck> checkOptional;
            Optional<Integer> portOptional;
            Objects.requireNonNull(instance, "instance");
            this.setName(instance.getName());
            this.setId(instance.getId());
            Optional<String> addressOptional = instance.getAddress();
            if (addressOptional.isPresent()) {
                this.setAddress(addressOptional);
            }
            if ((portOptional = instance.getPort()).isPresent()) {
                this.setPort(portOptional);
            }
            if ((checkOptional = instance.getCheck()).isPresent()) {
                this.setCheck(checkOptional);
            }
            this.addAllChecks(instance.getChecks());
            this.addAllTags(instance.getTags());
            this.putAllMeta(instance.getMeta());
            Optional<Boolean> enableTagOverrideOptional = instance.getEnableTagOverride();
            if (enableTagOverrideOptional.isPresent()) {
                this.setEnableTagOverride(enableTagOverrideOptional);
            }
            if ((serviceWeightsOptional = instance.getServiceWeights()).isPresent()) {
                this.setServiceWeights(serviceWeightsOptional);
            }
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Id")
        @CanIgnoreReturnValue
        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setAddress(String address) {
            this.address = Objects.requireNonNull(address, "address");
            return this;
        }

        @JsonProperty(value="Address")
        @CanIgnoreReturnValue
        public final Builder setAddress(Optional<String> address) {
            this.address = address.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setPort(int port) {
            this.port = port;
            return this;
        }

        @JsonProperty(value="Port")
        @CanIgnoreReturnValue
        public final Builder setPort(Optional<Integer> port) {
            this.port = port.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setCheck(Registration.RegCheck check) {
            this.check = Objects.requireNonNull(check, "check");
            return this;
        }

        @JsonProperty(value="Check")
        @CanIgnoreReturnValue
        public final Builder setCheck(Optional<? extends Registration.RegCheck> check) {
            this.check = check.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(Registration.RegCheck element) {
            this.checks.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(Registration.RegCheck ... elements) {
            this.checks.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Checks")
        @CanIgnoreReturnValue
        public final Builder setChecks(Iterable<? extends Registration.RegCheck> elements) {
            this.checks = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllChecks(Iterable<? extends Registration.RegCheck> elements) {
            this.checks.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            this.tags.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Tags")
        @CanIgnoreReturnValue
        public final Builder setTags(Iterable<String> elements) {
            this.tags = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            this.tags.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMeta(String key, String value) {
            this.meta.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
            this.meta.put(entry);
            return this;
        }

        @JsonProperty(value="Meta")
        @CanIgnoreReturnValue
        public final Builder setMeta(Map<String, ? extends String> entries) {
            this.meta = ImmutableMap.builder();
            return this.putAllMeta(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMeta(Map<String, ? extends String> entries) {
            this.meta.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setEnableTagOverride(boolean enableTagOverride) {
            this.enableTagOverride = enableTagOverride;
            return this;
        }

        @JsonProperty(value="EnableTagOverride")
        @CanIgnoreReturnValue
        public final Builder setEnableTagOverride(Optional<Boolean> enableTagOverride) {
            this.enableTagOverride = enableTagOverride.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setServiceWeights(ServiceWeights serviceWeights) {
            this.serviceWeights = Objects.requireNonNull(serviceWeights, "serviceWeights");
            return this;
        }

        @JsonProperty(value="Weights")
        @CanIgnoreReturnValue
        public final Builder setServiceWeights(Optional<? extends ServiceWeights> serviceWeights) {
            this.serviceWeights = serviceWeights.orElse(null);
            return this;
        }

        public ImmutableRegistration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRegistration(this.name, this.id, this.address, this.port, this.check, this.checks.build(), this.tags.build(), this.meta.build(), this.enableTagOverride, this.serviceWeights);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Registration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Registration", generator="Immutables")
    static final class Json
    extends Registration {
        @Nullable
        String name;
        @Nullable
        String id;
        @Nullable
        Optional<String> address = Optional.empty();
        @Nullable
        Optional<Integer> port = Optional.empty();
        @Nullable
        Optional<Registration.RegCheck> check = Optional.empty();
        @Nullable
        List<Registration.RegCheck> checks = ImmutableList.of();
        @Nullable
        List<String> tags = ImmutableList.of();
        @Nullable
        Map<String, String> meta = ImmutableMap.of();
        @Nullable
        Optional<Boolean> enableTagOverride = Optional.empty();
        @Nullable
        Optional<ServiceWeights> serviceWeights = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Address")
        public void setAddress(Optional<String> address) {
            this.address = address;
        }

        @JsonProperty(value="Port")
        public void setPort(Optional<Integer> port) {
            this.port = port;
        }

        @JsonProperty(value="Check")
        public void setCheck(Optional<Registration.RegCheck> check) {
            this.check = check;
        }

        @JsonProperty(value="Checks")
        public void setChecks(List<Registration.RegCheck> checks) {
            this.checks = checks;
        }

        @JsonProperty(value="Tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="Meta")
        public void setMeta(Map<String, String> meta) {
            this.meta = meta;
        }

        @JsonProperty(value="EnableTagOverride")
        public void setEnableTagOverride(Optional<Boolean> enableTagOverride) {
            this.enableTagOverride = enableTagOverride;
        }

        @JsonProperty(value="Weights")
        public void setServiceWeights(Optional<ServiceWeights> serviceWeights) {
            this.serviceWeights = serviceWeights;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Registration.RegCheck> getCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Registration.RegCheck> getChecks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getEnableTagOverride() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServiceWeights> getServiceWeights() {
            throw new UnsupportedOperationException();
        }
    }
}

