/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.agent.CheckV2;
import com.orbitz.consul.model.catalog.CatalogRegistration;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import com.orbitz.consul.model.catalog.WriteRequest;
import com.orbitz.consul.model.health.Service;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="CatalogRegistration", generator="Immutables")
@Immutable
public final class ImmutableCatalogRegistration
extends CatalogRegistration {
    @Nullable
    private final String id;
    @Nullable
    private final String datacenter;
    private final String node;
    @Nullable
    private final String address;
    private final ImmutableMap<String, String> nodeMeta;
    @Nullable
    private final TaggedAddresses taggedAddresses;
    @Nullable
    private final Service service;
    @Nullable
    private final CheckV2 check;
    @Nullable
    private final WriteRequest writeRequest;
    @Nullable
    private final Boolean skipNodeUpdate;

    private ImmutableCatalogRegistration(@Nullable String id, @Nullable String datacenter, String node, @Nullable String address, ImmutableMap<String, String> nodeMeta, @Nullable TaggedAddresses taggedAddresses, @Nullable Service service, @Nullable CheckV2 check, @Nullable WriteRequest writeRequest, @Nullable Boolean skipNodeUpdate) {
        this.id = id;
        this.datacenter = datacenter;
        this.node = node;
        this.address = address;
        this.nodeMeta = nodeMeta;
        this.taggedAddresses = taggedAddresses;
        this.service = service;
        this.check = check;
        this.writeRequest = writeRequest;
        this.skipNodeUpdate = skipNodeUpdate;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public Optional<String> getAddress() {
        return Optional.ofNullable(this.address);
    }

    @JsonProperty(value="NodeMeta")
    public ImmutableMap<String, String> getNodeMeta() {
        return this.nodeMeta;
    }

    @Override
    @JsonProperty(value="TaggedAddresses")
    public Optional<TaggedAddresses> getTaggedAddresses() {
        return Optional.ofNullable(this.taggedAddresses);
    }

    @Override
    @JsonProperty(value="Service")
    public Optional<Service> getService() {
        return Optional.ofNullable(this.service);
    }

    @Override
    @JsonProperty(value="Check")
    public Optional<CheckV2> getCheck() {
        return Optional.ofNullable(this.check);
    }

    @Override
    @JsonProperty(value="WriteRequest")
    public Optional<WriteRequest> getWriteRequest() {
        return Optional.ofNullable(this.writeRequest);
    }

    @Override
    @JsonProperty(value="SkipNodeUpdate")
    public Optional<Boolean> getSkipNodeUpdate() {
        return Optional.ofNullable(this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableCatalogRegistration(newValue, this.datacenter, this.node, this.address, this.nodeMeta, this.taggedAddresses, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableCatalogRegistration(value, this.datacenter, this.node, this.address, this.nodeMeta, this.taggedAddresses, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, newValue, this.node, this.address, this.nodeMeta, this.taggedAddresses, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, value, this.node, this.address, this.nodeMeta, this.taggedAddresses, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withNode(String value) {
        String newValue = Objects.requireNonNull(value, "node");
        if (this.node.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, newValue, this.address, this.nodeMeta, this.taggedAddresses, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (Objects.equals(this.address, newValue)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, newValue, this.nodeMeta, this.taggedAddresses, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withAddress(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.address, value)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, value, this.nodeMeta, this.taggedAddresses, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withNodeMeta(Map<String, ? extends String> entries) {
        if (this.nodeMeta == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, (ImmutableMap<String, String>)newValue, this.taggedAddresses, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withTaggedAddresses(TaggedAddresses value) {
        TaggedAddresses newValue = Objects.requireNonNull(value, "taggedAddresses");
        if (this.taggedAddresses == newValue) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta, newValue, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withTaggedAddresses(Optional<? extends TaggedAddresses> optional) {
        TaggedAddresses value = optional.orElse(null);
        if (this.taggedAddresses == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta, value, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withService(Service value) {
        Service newValue = Objects.requireNonNull(value, "service");
        if (this.service == newValue) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta, this.taggedAddresses, newValue, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withService(Optional<? extends Service> optional) {
        Service value = optional.orElse(null);
        if (this.service == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta, this.taggedAddresses, value, this.check, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withCheck(CheckV2 value) {
        CheckV2 newValue = Objects.requireNonNull(value, "check");
        if (this.check == newValue) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta, this.taggedAddresses, this.service, newValue, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withCheck(Optional<? extends CheckV2> optional) {
        CheckV2 value = optional.orElse(null);
        if (this.check == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta, this.taggedAddresses, this.service, value, this.writeRequest, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withWriteRequest(WriteRequest value) {
        WriteRequest newValue = Objects.requireNonNull(value, "writeRequest");
        if (this.writeRequest == newValue) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta, this.taggedAddresses, this.service, this.check, newValue, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withWriteRequest(Optional<? extends WriteRequest> optional) {
        WriteRequest value = optional.orElse(null);
        if (this.writeRequest == value) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta, this.taggedAddresses, this.service, this.check, value, this.skipNodeUpdate);
    }

    public final ImmutableCatalogRegistration withSkipNodeUpdate(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.skipNodeUpdate, newValue)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta, this.taggedAddresses, this.service, this.check, this.writeRequest, newValue);
    }

    public final ImmutableCatalogRegistration withSkipNodeUpdate(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.skipNodeUpdate, value)) {
            return this;
        }
        return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta, this.taggedAddresses, this.service, this.check, this.writeRequest, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogRegistration && this.equalTo((ImmutableCatalogRegistration)another);
    }

    private boolean equalTo(ImmutableCatalogRegistration another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.datacenter, another.datacenter) && this.node.equals(another.node) && Objects.equals(this.address, another.address) && this.nodeMeta.equals(another.nodeMeta) && Objects.equals(this.taggedAddresses, another.taggedAddresses) && Objects.equals(this.service, another.service) && Objects.equals(this.check, another.check) && Objects.equals(this.writeRequest, another.writeRequest) && Objects.equals(this.skipNodeUpdate, another.skipNodeUpdate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.datacenter);
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + Objects.hashCode(this.address);
        h += (h << 5) + this.nodeMeta.hashCode();
        h += (h << 5) + Objects.hashCode(this.taggedAddresses);
        h += (h << 5) + Objects.hashCode(this.service);
        h += (h << 5) + Objects.hashCode(this.check);
        h += (h << 5) + Objects.hashCode(this.writeRequest);
        h += (h << 5) + Objects.hashCode(this.skipNodeUpdate);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogRegistration").omitNullValues().add("id", (Object)this.id).add("datacenter", (Object)this.datacenter).add("node", (Object)this.node).add("address", (Object)this.address).add("nodeMeta", this.nodeMeta).add("taggedAddresses", (Object)this.taggedAddresses).add("service", (Object)this.service).add("check", (Object)this.check).add("writeRequest", (Object)this.writeRequest).add("skipNodeUpdate", (Object)this.skipNodeUpdate).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCatalogRegistration fromJson(Json json) {
        Builder builder = ImmutableCatalogRegistration.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.datacenter != null) {
            builder.setDatacenter(json.datacenter);
        }
        if (json.node != null) {
            builder.setNode(json.node);
        }
        if (json.address != null) {
            builder.setAddress(json.address);
        }
        if (json.nodeMeta != null) {
            builder.putAllNodeMeta(json.nodeMeta);
        }
        if (json.taggedAddresses != null) {
            builder.setTaggedAddresses(json.taggedAddresses);
        }
        if (json.service != null) {
            builder.setService(json.service);
        }
        if (json.check != null) {
            builder.setCheck(json.check);
        }
        if (json.writeRequest != null) {
            builder.setWriteRequest(json.writeRequest);
        }
        if (json.skipNodeUpdate != null) {
            builder.setSkipNodeUpdate(json.skipNodeUpdate);
        }
        return builder.build();
    }

    public static ImmutableCatalogRegistration copyOf(CatalogRegistration instance) {
        if (instance instanceof ImmutableCatalogRegistration) {
            return (ImmutableCatalogRegistration)instance;
        }
        return ImmutableCatalogRegistration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CatalogRegistration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String datacenter;
        @Nullable
        private String node;
        @Nullable
        private String address;
        private ImmutableMap.Builder<String, String> nodeMeta = ImmutableMap.builder();
        @Nullable
        private TaggedAddresses taggedAddresses;
        @Nullable
        private Service service;
        @Nullable
        private CheckV2 check;
        @Nullable
        private WriteRequest writeRequest;
        @Nullable
        private Boolean skipNodeUpdate;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogRegistration instance) {
            Optional<Boolean> skipNodeUpdateOptional;
            Optional<WriteRequest> writeRequestOptional;
            Optional<CheckV2> checkOptional;
            Optional<Service> serviceOptional;
            Optional<String> datacenterOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.getId();
            if (idOptional.isPresent()) {
                this.setId(idOptional);
            }
            if ((datacenterOptional = instance.getDatacenter()).isPresent()) {
                this.setDatacenter(datacenterOptional);
            }
            this.setNode(instance.getNode());
            Optional<String> addressOptional = instance.getAddress();
            if (addressOptional.isPresent()) {
                this.setAddress(addressOptional);
            }
            this.putAllNodeMeta(instance.getNodeMeta());
            Optional<TaggedAddresses> taggedAddressesOptional = instance.getTaggedAddresses();
            if (taggedAddressesOptional.isPresent()) {
                this.setTaggedAddresses(taggedAddressesOptional);
            }
            if ((serviceOptional = instance.getService()).isPresent()) {
                this.setService(serviceOptional);
            }
            if ((checkOptional = instance.getCheck()).isPresent()) {
                this.setCheck(checkOptional);
            }
            if ((writeRequestOptional = instance.getWriteRequest()).isPresent()) {
                this.setWriteRequest(writeRequestOptional);
            }
            if ((skipNodeUpdateOptional = instance.getSkipNodeUpdate()).isPresent()) {
                this.setSkipNodeUpdate(skipNodeUpdateOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder setId(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setDatacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @JsonProperty(value="Datacenter")
        @CanIgnoreReturnValue
        public final Builder setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder setNode(String node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setAddress(String address) {
            this.address = Objects.requireNonNull(address, "address");
            return this;
        }

        @JsonProperty(value="Address")
        @CanIgnoreReturnValue
        public final Builder setAddress(Optional<String> address) {
            this.address = address.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNodeMeta(String key, String value) {
            this.nodeMeta.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNodeMeta(Map.Entry<String, ? extends String> entry) {
            this.nodeMeta.put(entry);
            return this;
        }

        @JsonProperty(value="NodeMeta")
        @CanIgnoreReturnValue
        public final Builder setNodeMeta(Map<String, ? extends String> entries) {
            this.nodeMeta = ImmutableMap.builder();
            return this.putAllNodeMeta(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllNodeMeta(Map<String, ? extends String> entries) {
            this.nodeMeta.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setTaggedAddresses(TaggedAddresses taggedAddresses) {
            this.taggedAddresses = Objects.requireNonNull(taggedAddresses, "taggedAddresses");
            return this;
        }

        @JsonProperty(value="TaggedAddresses")
        @CanIgnoreReturnValue
        public final Builder setTaggedAddresses(Optional<? extends TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setService(Service service) {
            this.service = Objects.requireNonNull(service, "service");
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder setService(Optional<? extends Service> service) {
            this.service = service.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setCheck(CheckV2 check) {
            this.check = Objects.requireNonNull(check, "check");
            return this;
        }

        @JsonProperty(value="Check")
        @CanIgnoreReturnValue
        public final Builder setCheck(Optional<? extends CheckV2> check) {
            this.check = check.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setWriteRequest(WriteRequest writeRequest) {
            this.writeRequest = Objects.requireNonNull(writeRequest, "writeRequest");
            return this;
        }

        @JsonProperty(value="WriteRequest")
        @CanIgnoreReturnValue
        public final Builder setWriteRequest(Optional<? extends WriteRequest> writeRequest) {
            this.writeRequest = writeRequest.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setSkipNodeUpdate(boolean skipNodeUpdate) {
            this.skipNodeUpdate = skipNodeUpdate;
            return this;
        }

        @JsonProperty(value="SkipNodeUpdate")
        @CanIgnoreReturnValue
        public final Builder setSkipNodeUpdate(Optional<Boolean> skipNodeUpdate) {
            this.skipNodeUpdate = skipNodeUpdate.orElse(null);
            return this;
        }

        public ImmutableCatalogRegistration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogRegistration(this.id, this.datacenter, this.node, this.address, this.nodeMeta.build(), this.taggedAddresses, this.service, this.check, this.writeRequest, this.skipNodeUpdate);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            return "Cannot build CatalogRegistration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CatalogRegistration", generator="Immutables")
    static final class Json
    extends CatalogRegistration {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        Optional<String> datacenter = Optional.empty();
        @Nullable
        String node;
        @Nullable
        Optional<String> address = Optional.empty();
        @Nullable
        Map<String, String> nodeMeta = ImmutableMap.of();
        @Nullable
        Optional<TaggedAddresses> taggedAddresses = Optional.empty();
        @Nullable
        Optional<Service> service = Optional.empty();
        @Nullable
        Optional<CheckV2> check = Optional.empty();
        @Nullable
        Optional<WriteRequest> writeRequest = Optional.empty();
        @Nullable
        Optional<Boolean> skipNodeUpdate = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(Optional<String> address) {
            this.address = address;
        }

        @JsonProperty(value="NodeMeta")
        public void setNodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = nodeMeta;
        }

        @JsonProperty(value="TaggedAddresses")
        public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses;
        }

        @JsonProperty(value="Service")
        public void setService(Optional<Service> service) {
            this.service = service;
        }

        @JsonProperty(value="Check")
        public void setCheck(Optional<CheckV2> check) {
            this.check = check;
        }

        @JsonProperty(value="WriteRequest")
        public void setWriteRequest(Optional<WriteRequest> writeRequest) {
            this.writeRequest = writeRequest;
        }

        @JsonProperty(value="SkipNodeUpdate")
        public void setSkipNodeUpdate(Optional<Boolean> skipNodeUpdate) {
            this.skipNodeUpdate = skipNodeUpdate;
        }

        @Override
        public Optional<String> getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getNodeMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TaggedAddresses> getTaggedAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Service> getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CheckV2> getCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<WriteRequest> getWriteRequest() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getSkipNodeUpdate() {
            throw new UnsupportedOperationException();
        }
    }
}

