/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.catalog.CatalogService;
import com.orbitz.consul.model.catalog.ServiceWeights;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="CatalogService", generator="Immutables")
@Immutable
public final class ImmutableCatalogService
extends CatalogService {
    @Nullable
    private final UUID iD;
    private final String node;
    private final String address;
    @Nullable
    private final String datacenter;
    @Nullable
    private final TaggedAddresses taggedAddresses;
    private final String serviceName;
    private final String serviceId;
    private final String serviceAddress;
    @Nullable
    private final Boolean serviceEnableTagOverride;
    private final int servicePort;
    private final ImmutableList<String> serviceTags;
    private final ImmutableMap<String, String> serviceMeta;
    @Nullable
    private final ServiceWeights serviceWeights;
    private final ImmutableMap<String, String> nodeMeta;
    @Nullable
    private final Long createIndex;
    @Nullable
    private final Long modifyIndex;

    private ImmutableCatalogService(@Nullable UUID iD, String node, String address, @Nullable String datacenter, @Nullable TaggedAddresses taggedAddresses, String serviceName, String serviceId, String serviceAddress, @Nullable Boolean serviceEnableTagOverride, int servicePort, ImmutableList<String> serviceTags, ImmutableMap<String, String> serviceMeta, @Nullable ServiceWeights serviceWeights, ImmutableMap<String, String> nodeMeta, @Nullable Long createIndex, @Nullable Long modifyIndex) {
        this.iD = iD;
        this.node = node;
        this.address = address;
        this.datacenter = datacenter;
        this.taggedAddresses = taggedAddresses;
        this.serviceName = serviceName;
        this.serviceId = serviceId;
        this.serviceAddress = serviceAddress;
        this.serviceEnableTagOverride = serviceEnableTagOverride;
        this.servicePort = servicePort;
        this.serviceTags = serviceTags;
        this.serviceMeta = serviceMeta;
        this.serviceWeights = serviceWeights;
        this.nodeMeta = nodeMeta;
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<UUID> getID() {
        return Optional.ofNullable(this.iD);
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    @JsonProperty(value="TaggedAddresses")
    public Optional<TaggedAddresses> getTaggedAddresses() {
        return Optional.ofNullable(this.taggedAddresses);
    }

    @Override
    @JsonProperty(value="ServiceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    @JsonProperty(value="ServiceID")
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @JsonProperty(value="ServiceAddress")
    public String getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    @JsonProperty(value="ServiceEnableTagOverride")
    public Optional<Boolean> getServiceEnableTagOverride() {
        return Optional.ofNullable(this.serviceEnableTagOverride);
    }

    @Override
    @JsonProperty(value="ServicePort")
    public int getServicePort() {
        return this.servicePort;
    }

    @JsonProperty(value="ServiceTags")
    public ImmutableList<String> getServiceTags() {
        return this.serviceTags;
    }

    @JsonProperty(value="ServiceMeta")
    public ImmutableMap<String, String> getServiceMeta() {
        return this.serviceMeta;
    }

    @Override
    @JsonProperty(value="ServiceWeights")
    public Optional<ServiceWeights> getServiceWeights() {
        return Optional.ofNullable(this.serviceWeights);
    }

    @JsonProperty(value="NodeMeta")
    public ImmutableMap<String, String> getNodeMeta() {
        return this.nodeMeta;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public OptionalLong getCreateIndex() {
        return this.createIndex != null ? OptionalLong.of(this.createIndex) : OptionalLong.empty();
    }

    @Override
    @JsonProperty(value="ModifyIndex")
    public OptionalLong getModifyIndex() {
        return this.modifyIndex != null ? OptionalLong.of(this.modifyIndex) : OptionalLong.empty();
    }

    public final ImmutableCatalogService withID(UUID value) {
        UUID newValue = Objects.requireNonNull(value, "iD");
        if (this.iD == newValue) {
            return this;
        }
        return new ImmutableCatalogService(newValue, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withID(Optional<? extends UUID> optional) {
        UUID value = optional.orElse(null);
        if (this.iD == value) {
            return this;
        }
        return new ImmutableCatalogService(value, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withNode(String value) {
        String newValue = Objects.requireNonNull(value, "node");
        if (this.node.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, newValue, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, newValue, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, newValue, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, value, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withTaggedAddresses(TaggedAddresses value) {
        TaggedAddresses newValue = Objects.requireNonNull(value, "taggedAddresses");
        if (this.taggedAddresses == newValue) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, newValue, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withTaggedAddresses(Optional<? extends TaggedAddresses> optional) {
        TaggedAddresses value = optional.orElse(null);
        if (this.taggedAddresses == value) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, value, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServiceName(String value) {
        String newValue = Objects.requireNonNull(value, "serviceName");
        if (this.serviceName.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, newValue, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServiceId(String value) {
        String newValue = Objects.requireNonNull(value, "serviceId");
        if (this.serviceId.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, newValue, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServiceAddress(String value) {
        String newValue = Objects.requireNonNull(value, "serviceAddress");
        if (this.serviceAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, newValue, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServiceEnableTagOverride(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.serviceEnableTagOverride, newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, newValue, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServiceEnableTagOverride(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.serviceEnableTagOverride, value)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, value, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServicePort(int value) {
        if (this.servicePort == value) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, value, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServiceTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, (ImmutableList<String>)newValue, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServiceTags(Iterable<String> elements) {
        if (this.serviceTags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, (ImmutableList<String>)newValue, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServiceMeta(Map<String, ? extends String> entries) {
        if (this.serviceMeta == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, (ImmutableMap<String, String>)newValue, this.serviceWeights, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServiceWeights(ServiceWeights value) {
        ServiceWeights newValue = Objects.requireNonNull(value, "serviceWeights");
        if (this.serviceWeights == newValue) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, newValue, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withServiceWeights(Optional<? extends ServiceWeights> optional) {
        ServiceWeights value = optional.orElse(null);
        if (this.serviceWeights == value) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, value, this.nodeMeta, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withNodeMeta(Map<String, ? extends String> entries) {
        if (this.nodeMeta == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, (ImmutableMap<String, String>)newValue, this.createIndex, this.modifyIndex);
    }

    public final ImmutableCatalogService withCreateIndex(long value) {
        Long newValue = value;
        if (Objects.equals(this.createIndex, newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, newValue, this.modifyIndex);
    }

    public final ImmutableCatalogService withCreateIndex(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.createIndex, value)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, value, this.modifyIndex);
    }

    public final ImmutableCatalogService withModifyIndex(long value) {
        Long newValue = value;
        if (Objects.equals(this.modifyIndex, newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, newValue);
    }

    public final ImmutableCatalogService withModifyIndex(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.modifyIndex, value)) {
            return this;
        }
        return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.serviceWeights, this.nodeMeta, this.createIndex, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogService && this.equalTo((ImmutableCatalogService)another);
    }

    private boolean equalTo(ImmutableCatalogService another) {
        return Objects.equals(this.iD, another.iD) && this.node.equals(another.node) && this.address.equals(another.address) && Objects.equals(this.datacenter, another.datacenter) && Objects.equals(this.taggedAddresses, another.taggedAddresses) && this.serviceName.equals(another.serviceName) && this.serviceId.equals(another.serviceId) && this.serviceAddress.equals(another.serviceAddress) && Objects.equals(this.serviceEnableTagOverride, another.serviceEnableTagOverride) && this.servicePort == another.servicePort && this.serviceTags.equals(another.serviceTags) && this.serviceMeta.equals(another.serviceMeta) && Objects.equals(this.serviceWeights, another.serviceWeights) && this.nodeMeta.equals(another.nodeMeta) && Objects.equals(this.createIndex, another.createIndex) && Objects.equals(this.modifyIndex, another.modifyIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.iD);
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.address.hashCode();
        h += (h << 5) + Objects.hashCode(this.datacenter);
        h += (h << 5) + Objects.hashCode(this.taggedAddresses);
        h += (h << 5) + this.serviceName.hashCode();
        h += (h << 5) + this.serviceId.hashCode();
        h += (h << 5) + this.serviceAddress.hashCode();
        h += (h << 5) + Objects.hashCode(this.serviceEnableTagOverride);
        h += (h << 5) + this.servicePort;
        h += (h << 5) + this.serviceTags.hashCode();
        h += (h << 5) + this.serviceMeta.hashCode();
        h += (h << 5) + Objects.hashCode(this.serviceWeights);
        h += (h << 5) + this.nodeMeta.hashCode();
        h += (h << 5) + Objects.hashCode(this.createIndex);
        h += (h << 5) + Objects.hashCode(this.modifyIndex);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogService").omitNullValues().add("iD", (Object)this.iD).add("node", (Object)this.node).add("address", (Object)this.address).add("datacenter", (Object)this.datacenter).add("taggedAddresses", (Object)this.taggedAddresses).add("serviceName", (Object)this.serviceName).add("serviceId", (Object)this.serviceId).add("serviceAddress", (Object)this.serviceAddress).add("serviceEnableTagOverride", (Object)this.serviceEnableTagOverride).add("servicePort", this.servicePort).add("serviceTags", this.serviceTags).add("serviceMeta", this.serviceMeta).add("serviceWeights", (Object)this.serviceWeights).add("nodeMeta", this.nodeMeta).add("createIndex", (Object)this.createIndex).add("modifyIndex", (Object)this.modifyIndex).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCatalogService fromJson(Json json) {
        Builder builder = ImmutableCatalogService.builder();
        if (json.iD != null) {
            builder.setID(json.iD);
        }
        if (json.node != null) {
            builder.setNode(json.node);
        }
        if (json.address != null) {
            builder.setAddress(json.address);
        }
        if (json.datacenter != null) {
            builder.setDatacenter(json.datacenter);
        }
        if (json.taggedAddresses != null) {
            builder.setTaggedAddresses(json.taggedAddresses);
        }
        if (json.serviceName != null) {
            builder.setServiceName(json.serviceName);
        }
        if (json.serviceId != null) {
            builder.setServiceId(json.serviceId);
        }
        if (json.serviceAddress != null) {
            builder.setServiceAddress(json.serviceAddress);
        }
        if (json.serviceEnableTagOverride != null) {
            builder.setServiceEnableTagOverride(json.serviceEnableTagOverride);
        }
        if (json.servicePortIsSet) {
            builder.setServicePort(json.servicePort);
        }
        if (json.serviceTags != null) {
            builder.addAllServiceTags(json.serviceTags);
        }
        if (json.serviceMeta != null) {
            builder.putAllServiceMeta(json.serviceMeta);
        }
        if (json.serviceWeights != null) {
            builder.setServiceWeights(json.serviceWeights);
        }
        if (json.nodeMeta != null) {
            builder.putAllNodeMeta(json.nodeMeta);
        }
        if (json.createIndex != null) {
            builder.setCreateIndex(json.createIndex);
        }
        if (json.modifyIndex != null) {
            builder.setModifyIndex(json.modifyIndex);
        }
        return builder.build();
    }

    public static ImmutableCatalogService copyOf(CatalogService instance) {
        if (instance instanceof ImmutableCatalogService) {
            return (ImmutableCatalogService)instance;
        }
        return ImmutableCatalogService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CatalogService", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private static final long INIT_BIT_SERVICE_NAME = 4L;
        private static final long INIT_BIT_SERVICE_ID = 8L;
        private static final long INIT_BIT_SERVICE_ADDRESS = 16L;
        private static final long INIT_BIT_SERVICE_PORT = 32L;
        private long initBits = 63L;
        @Nullable
        private UUID iD;
        @Nullable
        private String node;
        @Nullable
        private String address;
        @Nullable
        private String datacenter;
        @Nullable
        private TaggedAddresses taggedAddresses;
        @Nullable
        private String serviceName;
        @Nullable
        private String serviceId;
        @Nullable
        private String serviceAddress;
        @Nullable
        private Boolean serviceEnableTagOverride;
        private int servicePort;
        private ImmutableList.Builder<String> serviceTags = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> serviceMeta = ImmutableMap.builder();
        @Nullable
        private ServiceWeights serviceWeights;
        private ImmutableMap.Builder<String, String> nodeMeta = ImmutableMap.builder();
        @Nullable
        private Long createIndex;
        @Nullable
        private Long modifyIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogService instance) {
            OptionalLong modifyIndexOptional;
            Optional<TaggedAddresses> taggedAddressesOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<UUID> iDOptional = instance.getID();
            if (iDOptional.isPresent()) {
                this.setID(iDOptional);
            }
            this.setNode(instance.getNode());
            this.setAddress(instance.getAddress());
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.setDatacenter(datacenterOptional);
            }
            if ((taggedAddressesOptional = instance.getTaggedAddresses()).isPresent()) {
                this.setTaggedAddresses(taggedAddressesOptional);
            }
            this.setServiceName(instance.getServiceName());
            this.setServiceId(instance.getServiceId());
            this.setServiceAddress(instance.getServiceAddress());
            Optional<Boolean> serviceEnableTagOverrideOptional = instance.getServiceEnableTagOverride();
            if (serviceEnableTagOverrideOptional.isPresent()) {
                this.setServiceEnableTagOverride(serviceEnableTagOverrideOptional);
            }
            this.setServicePort(instance.getServicePort());
            this.addAllServiceTags(instance.getServiceTags());
            this.putAllServiceMeta(instance.getServiceMeta());
            Optional<ServiceWeights> serviceWeightsOptional = instance.getServiceWeights();
            if (serviceWeightsOptional.isPresent()) {
                this.setServiceWeights(serviceWeightsOptional);
            }
            this.putAllNodeMeta(instance.getNodeMeta());
            OptionalLong createIndexOptional = instance.getCreateIndex();
            if (createIndexOptional.isPresent()) {
                this.setCreateIndex(createIndexOptional);
            }
            if ((modifyIndexOptional = instance.getModifyIndex()).isPresent()) {
                this.setModifyIndex(modifyIndexOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setID(UUID iD) {
            this.iD = Objects.requireNonNull(iD, "iD");
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder setID(Optional<? extends UUID> iD) {
            this.iD = iD.orElse(null);
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder setNode(String node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Address")
        @CanIgnoreReturnValue
        public final Builder setAddress(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setDatacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @JsonProperty(value="Datacenter")
        @CanIgnoreReturnValue
        public final Builder setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setTaggedAddresses(TaggedAddresses taggedAddresses) {
            this.taggedAddresses = Objects.requireNonNull(taggedAddresses, "taggedAddresses");
            return this;
        }

        @JsonProperty(value="TaggedAddresses")
        @CanIgnoreReturnValue
        public final Builder setTaggedAddresses(Optional<? extends TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses.orElse(null);
            return this;
        }

        @JsonProperty(value="ServiceName")
        @CanIgnoreReturnValue
        public final Builder setServiceName(String serviceName) {
            this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="ServiceID")
        @CanIgnoreReturnValue
        public final Builder setServiceId(String serviceId) {
            this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="ServiceAddress")
        @CanIgnoreReturnValue
        public final Builder setServiceAddress(String serviceAddress) {
            this.serviceAddress = Objects.requireNonNull(serviceAddress, "serviceAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setServiceEnableTagOverride(boolean serviceEnableTagOverride) {
            this.serviceEnableTagOverride = serviceEnableTagOverride;
            return this;
        }

        @JsonProperty(value="ServiceEnableTagOverride")
        @CanIgnoreReturnValue
        public final Builder setServiceEnableTagOverride(Optional<Boolean> serviceEnableTagOverride) {
            this.serviceEnableTagOverride = serviceEnableTagOverride.orElse(null);
            return this;
        }

        @JsonProperty(value="ServicePort")
        @CanIgnoreReturnValue
        public final Builder setServicePort(int servicePort) {
            this.servicePort = servicePort;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceTags(String element) {
            this.serviceTags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceTags(String ... elements) {
            this.serviceTags.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="ServiceTags")
        @CanIgnoreReturnValue
        public final Builder setServiceTags(Iterable<String> elements) {
            this.serviceTags = ImmutableList.builder();
            return this.addAllServiceTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllServiceTags(Iterable<String> elements) {
            this.serviceTags.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putServiceMeta(String key, String value) {
            this.serviceMeta.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putServiceMeta(Map.Entry<String, ? extends String> entry) {
            this.serviceMeta.put(entry);
            return this;
        }

        @JsonProperty(value="ServiceMeta")
        @CanIgnoreReturnValue
        public final Builder setServiceMeta(Map<String, ? extends String> entries) {
            this.serviceMeta = ImmutableMap.builder();
            return this.putAllServiceMeta(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllServiceMeta(Map<String, ? extends String> entries) {
            this.serviceMeta.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setServiceWeights(ServiceWeights serviceWeights) {
            this.serviceWeights = Objects.requireNonNull(serviceWeights, "serviceWeights");
            return this;
        }

        @JsonProperty(value="ServiceWeights")
        @CanIgnoreReturnValue
        public final Builder setServiceWeights(Optional<? extends ServiceWeights> serviceWeights) {
            this.serviceWeights = serviceWeights.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNodeMeta(String key, String value) {
            this.nodeMeta.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNodeMeta(Map.Entry<String, ? extends String> entry) {
            this.nodeMeta.put(entry);
            return this;
        }

        @JsonProperty(value="NodeMeta")
        @CanIgnoreReturnValue
        public final Builder setNodeMeta(Map<String, ? extends String> entries) {
            this.nodeMeta = ImmutableMap.builder();
            return this.putAllNodeMeta(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllNodeMeta(Map<String, ? extends String> entries) {
            this.nodeMeta.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setCreateIndex(long createIndex) {
            this.createIndex = createIndex;
            return this;
        }

        @JsonProperty(value="CreateIndex")
        @CanIgnoreReturnValue
        public final Builder setCreateIndex(OptionalLong createIndex) {
            this.createIndex = createIndex.isPresent() ? Long.valueOf(createIndex.getAsLong()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setModifyIndex(long modifyIndex) {
            this.modifyIndex = modifyIndex;
            return this;
        }

        @JsonProperty(value="ModifyIndex")
        @CanIgnoreReturnValue
        public final Builder setModifyIndex(OptionalLong modifyIndex) {
            this.modifyIndex = modifyIndex.isPresent() ? Long.valueOf(modifyIndex.getAsLong()) : null;
            return this;
        }

        public ImmutableCatalogService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogService(this.iD, this.node, this.address, this.datacenter, this.taggedAddresses, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags.build(), this.serviceMeta.build(), this.serviceWeights, this.nodeMeta.build(), this.createIndex, this.modifyIndex);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("serviceName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("serviceId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("serviceAddress");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("servicePort");
            }
            return "Cannot build CatalogService, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CatalogService", generator="Immutables")
    static final class Json
    extends CatalogService {
        @Nullable
        Optional<UUID> iD = Optional.empty();
        @Nullable
        String node;
        @Nullable
        String address;
        @Nullable
        Optional<String> datacenter = Optional.empty();
        @Nullable
        Optional<TaggedAddresses> taggedAddresses = Optional.empty();
        @Nullable
        String serviceName;
        @Nullable
        String serviceId;
        @Nullable
        String serviceAddress;
        @Nullable
        Optional<Boolean> serviceEnableTagOverride = Optional.empty();
        int servicePort;
        boolean servicePortIsSet;
        @Nullable
        List<String> serviceTags = ImmutableList.of();
        @Nullable
        Map<String, String> serviceMeta = ImmutableMap.of();
        @Nullable
        Optional<ServiceWeights> serviceWeights = Optional.empty();
        @Nullable
        Map<String, String> nodeMeta = ImmutableMap.of();
        @Nullable
        OptionalLong createIndex = OptionalLong.empty();
        @Nullable
        OptionalLong modifyIndex = OptionalLong.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setID(Optional<UUID> iD) {
            this.iD = iD;
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="TaggedAddresses")
        public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses;
        }

        @JsonProperty(value="ServiceName")
        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="ServiceAddress")
        public void setServiceAddress(String serviceAddress) {
            this.serviceAddress = serviceAddress;
        }

        @JsonProperty(value="ServiceEnableTagOverride")
        public void setServiceEnableTagOverride(Optional<Boolean> serviceEnableTagOverride) {
            this.serviceEnableTagOverride = serviceEnableTagOverride;
        }

        @JsonProperty(value="ServicePort")
        public void setServicePort(int servicePort) {
            this.servicePort = servicePort;
            this.servicePortIsSet = true;
        }

        @JsonProperty(value="ServiceTags")
        public void setServiceTags(List<String> serviceTags) {
            this.serviceTags = serviceTags;
        }

        @JsonProperty(value="ServiceMeta")
        public void setServiceMeta(Map<String, String> serviceMeta) {
            this.serviceMeta = serviceMeta;
        }

        @JsonProperty(value="ServiceWeights")
        public void setServiceWeights(Optional<ServiceWeights> serviceWeights) {
            this.serviceWeights = serviceWeights;
        }

        @JsonProperty(value="NodeMeta")
        public void setNodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = nodeMeta;
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(OptionalLong createIndex) {
            this.createIndex = createIndex;
        }

        @JsonProperty(value="ModifyIndex")
        public void setModifyIndex(OptionalLong modifyIndex) {
            this.modifyIndex = modifyIndex;
        }

        @Override
        public Optional<UUID> getID() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TaggedAddresses> getTaggedAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getServiceEnableTagOverride() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getServicePort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getServiceTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getServiceMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServiceWeights> getServiceWeights() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getNodeMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalLong getCreateIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalLong getModifyIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

