/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.catalog.NodeService;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="NodeService", generator="Immutables")
@Immutable
public final class ImmutableNodeService
extends NodeService {
    private final String id;
    private final String service;
    @Nullable
    private final TaggedAddresses taggedAddresses;
    private final ImmutableList<String> tags;
    @Nullable
    private final String address;
    private final ImmutableMap<String, String> meta;
    @Nullable
    private final Integer port;
    @Nullable
    private final String namespace;

    private ImmutableNodeService(String id, String service, @Nullable TaggedAddresses taggedAddresses, ImmutableList<String> tags, @Nullable String address, ImmutableMap<String, String> meta, @Nullable Integer port, @Nullable String namespace) {
        this.id = id;
        this.service = service;
        this.taggedAddresses = taggedAddresses;
        this.tags = tags;
        this.address = address;
        this.meta = meta;
        this.port = port;
        this.namespace = namespace;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Service")
    public String getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="TaggedAddresses")
    public Optional<TaggedAddresses> getTaggedAddresses() {
        return Optional.ofNullable(this.taggedAddresses);
    }

    @JsonProperty(value="Tags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="Address")
    public Optional<String> getAddress() {
        return Optional.ofNullable(this.address);
    }

    @JsonProperty(value="Meta")
    public ImmutableMap<String, String> getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty(value="Port")
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    @Override
    @JsonProperty(value="Namespace")
    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    public final ImmutableNodeService withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeService(newValue, this.service, this.taggedAddresses, this.tags, this.address, this.meta, this.port, this.namespace);
    }

    public final ImmutableNodeService withService(String value) {
        String newValue = Objects.requireNonNull(value, "service");
        if (this.service.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeService(this.id, newValue, this.taggedAddresses, this.tags, this.address, this.meta, this.port, this.namespace);
    }

    public final ImmutableNodeService withTaggedAddresses(TaggedAddresses value) {
        TaggedAddresses newValue = Objects.requireNonNull(value, "taggedAddresses");
        if (this.taggedAddresses == newValue) {
            return this;
        }
        return new ImmutableNodeService(this.id, this.service, newValue, this.tags, this.address, this.meta, this.port, this.namespace);
    }

    public final ImmutableNodeService withTaggedAddresses(Optional<? extends TaggedAddresses> optional) {
        TaggedAddresses value = optional.orElse(null);
        if (this.taggedAddresses == value) {
            return this;
        }
        return new ImmutableNodeService(this.id, this.service, value, this.tags, this.address, this.meta, this.port, this.namespace);
    }

    public final ImmutableNodeService withTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableNodeService(this.id, this.service, this.taggedAddresses, (ImmutableList<String>)newValue, this.address, this.meta, this.port, this.namespace);
    }

    public final ImmutableNodeService withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableNodeService(this.id, this.service, this.taggedAddresses, (ImmutableList<String>)newValue, this.address, this.meta, this.port, this.namespace);
    }

    public final ImmutableNodeService withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (Objects.equals(this.address, newValue)) {
            return this;
        }
        return new ImmutableNodeService(this.id, this.service, this.taggedAddresses, this.tags, newValue, this.meta, this.port, this.namespace);
    }

    public final ImmutableNodeService withAddress(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.address, value)) {
            return this;
        }
        return new ImmutableNodeService(this.id, this.service, this.taggedAddresses, this.tags, value, this.meta, this.port, this.namespace);
    }

    public final ImmutableNodeService withMeta(Map<String, ? extends String> entries) {
        if (this.meta == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableNodeService(this.id, this.service, this.taggedAddresses, this.tags, this.address, (ImmutableMap<String, String>)newValue, this.port, this.namespace);
    }

    public final ImmutableNodeService withPort(int value) {
        Integer newValue = value;
        if (Objects.equals(this.port, newValue)) {
            return this;
        }
        return new ImmutableNodeService(this.id, this.service, this.taggedAddresses, this.tags, this.address, this.meta, newValue, this.namespace);
    }

    public final ImmutableNodeService withPort(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.port, value)) {
            return this;
        }
        return new ImmutableNodeService(this.id, this.service, this.taggedAddresses, this.tags, this.address, this.meta, value, this.namespace);
    }

    public final ImmutableNodeService withNamespace(String value) {
        String newValue = Objects.requireNonNull(value, "namespace");
        if (Objects.equals(this.namespace, newValue)) {
            return this;
        }
        return new ImmutableNodeService(this.id, this.service, this.taggedAddresses, this.tags, this.address, this.meta, this.port, newValue);
    }

    public final ImmutableNodeService withNamespace(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.namespace, value)) {
            return this;
        }
        return new ImmutableNodeService(this.id, this.service, this.taggedAddresses, this.tags, this.address, this.meta, this.port, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeService && this.equalTo((ImmutableNodeService)another);
    }

    private boolean equalTo(ImmutableNodeService another) {
        return this.id.equals(another.id) && this.service.equals(another.service) && Objects.equals(this.taggedAddresses, another.taggedAddresses) && this.tags.equals(another.tags) && Objects.equals(this.address, another.address) && this.meta.equals(another.meta) && Objects.equals(this.port, another.port) && Objects.equals(this.namespace, another.namespace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.service.hashCode();
        h += (h << 5) + Objects.hashCode(this.taggedAddresses);
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + Objects.hashCode(this.address);
        h += (h << 5) + this.meta.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode(this.namespace);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NodeService").omitNullValues().add("id", (Object)this.id).add("service", (Object)this.service).add("taggedAddresses", (Object)this.taggedAddresses).add("tags", this.tags).add("address", (Object)this.address).add("meta", this.meta).add("port", (Object)this.port).add("namespace", (Object)this.namespace).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNodeService fromJson(Json json) {
        Builder builder = ImmutableNodeService.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.service != null) {
            builder.setService(json.service);
        }
        if (json.taggedAddresses != null) {
            builder.setTaggedAddresses(json.taggedAddresses);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.address != null) {
            builder.setAddress(json.address);
        }
        if (json.meta != null) {
            builder.putAllMeta(json.meta);
        }
        if (json.port != null) {
            builder.setPort(json.port);
        }
        if (json.namespace != null) {
            builder.setNamespace(json.namespace);
        }
        return builder.build();
    }

    public static ImmutableNodeService copyOf(NodeService instance) {
        if (instance instanceof ImmutableNodeService) {
            return (ImmutableNodeService)instance;
        }
        return ImmutableNodeService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeService", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String service;
        @Nullable
        private TaggedAddresses taggedAddresses;
        private ImmutableList.Builder<String> tags = ImmutableList.builder();
        @Nullable
        private String address;
        private ImmutableMap.Builder<String, String> meta = ImmutableMap.builder();
        @Nullable
        private Integer port;
        @Nullable
        private String namespace;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NodeService instance) {
            Optional<String> namespaceOptional;
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            this.setService(instance.getService());
            Optional<TaggedAddresses> taggedAddressesOptional = instance.getTaggedAddresses();
            if (taggedAddressesOptional.isPresent()) {
                this.setTaggedAddresses(taggedAddressesOptional);
            }
            this.addAllTags(instance.getTags());
            Optional<String> addressOptional = instance.getAddress();
            if (addressOptional.isPresent()) {
                this.setAddress(addressOptional);
            }
            this.putAllMeta(instance.getMeta());
            Optional<Integer> portOptional = instance.getPort();
            if (portOptional.isPresent()) {
                this.setPort(portOptional);
            }
            if ((namespaceOptional = instance.getNamespace()).isPresent()) {
                this.setNamespace(namespaceOptional);
            }
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder setService(String service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setTaggedAddresses(TaggedAddresses taggedAddresses) {
            this.taggedAddresses = Objects.requireNonNull(taggedAddresses, "taggedAddresses");
            return this;
        }

        @JsonProperty(value="TaggedAddresses")
        @CanIgnoreReturnValue
        public final Builder setTaggedAddresses(Optional<? extends TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            this.tags.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        @CanIgnoreReturnValue
        public final Builder setTags(Iterable<String> elements) {
            this.tags = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            this.tags.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setAddress(String address) {
            this.address = Objects.requireNonNull(address, "address");
            return this;
        }

        @JsonProperty(value="Address")
        @CanIgnoreReturnValue
        public final Builder setAddress(Optional<String> address) {
            this.address = address.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMeta(String key, String value) {
            this.meta.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMeta(Map.Entry<String, ? extends String> entry) {
            this.meta.put(entry);
            return this;
        }

        @JsonProperty(value="Meta")
        @CanIgnoreReturnValue
        public final Builder setMeta(Map<String, ? extends String> entries) {
            this.meta = ImmutableMap.builder();
            return this.putAllMeta(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMeta(Map<String, ? extends String> entries) {
            this.meta.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setPort(int port) {
            this.port = port;
            return this;
        }

        @JsonProperty(value="Port")
        @CanIgnoreReturnValue
        public final Builder setPort(Optional<Integer> port) {
            this.port = port.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setNamespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            return this;
        }

        @JsonProperty(value="Namespace")
        @CanIgnoreReturnValue
        public final Builder setNamespace(Optional<String> namespace) {
            this.namespace = namespace.orElse(null);
            return this;
        }

        public ImmutableNodeService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeService(this.id, this.service, this.taggedAddresses, this.tags.build(), this.address, this.meta.build(), this.port, this.namespace);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build NodeService, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NodeService", generator="Immutables")
    static final class Json
    extends NodeService {
        @Nullable
        String id;
        @Nullable
        String service;
        @Nullable
        Optional<TaggedAddresses> taggedAddresses = Optional.empty();
        @Nullable
        List<String> tags = ImmutableList.of();
        @Nullable
        Optional<String> address = Optional.empty();
        @Nullable
        Map<String, String> meta = ImmutableMap.of();
        @Nullable
        Optional<Integer> port = Optional.empty();
        @Nullable
        Optional<String> namespace = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Service")
        public void setService(String service) {
            this.service = service;
        }

        @JsonProperty(value="TaggedAddresses")
        public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses;
        }

        @JsonProperty(value="Tags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="Address")
        public void setAddress(Optional<String> address) {
            this.address = address;
        }

        @JsonProperty(value="Meta")
        public void setMeta(Map<String, String> meta) {
            this.meta = meta;
        }

        @JsonProperty(value="Port")
        public void setPort(Optional<Integer> port) {
            this.port = port;
        }

        @JsonProperty(value="Namespace")
        public void setNamespace(Optional<String> namespace) {
            this.namespace = namespace;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TaggedAddresses> getTaggedAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNamespace() {
            throw new UnsupportedOperationException();
        }
    }
}

