/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.catalog.NodeService;
import com.orbitz.consul.model.catalog.NodeServicesResponse;
import com.orbitz.consul.model.health.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="NodeServicesResponse", generator="Immutables")
@Immutable
public final class ImmutableNodeServicesResponse
extends NodeServicesResponse {
    private final Node nodes;
    private final ImmutableList<NodeService> services;

    private ImmutableNodeServicesResponse(Node nodes, ImmutableList<NodeService> services) {
        this.nodes = nodes;
        this.services = services;
    }

    @Override
    @JsonProperty(value="Node")
    public Node getNodes() {
        return this.nodes;
    }

    @JsonProperty(value="Services")
    public ImmutableList<NodeService> getServices() {
        return this.services;
    }

    public final ImmutableNodeServicesResponse withNodes(Node value) {
        if (this.nodes == value) {
            return this;
        }
        Node newValue = Objects.requireNonNull(value, "nodes");
        return new ImmutableNodeServicesResponse(newValue, this.services);
    }

    public final ImmutableNodeServicesResponse withServices(NodeService ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableNodeServicesResponse(this.nodes, (ImmutableList<NodeService>)newValue);
    }

    public final ImmutableNodeServicesResponse withServices(Iterable<? extends NodeService> elements) {
        if (this.services == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableNodeServicesResponse(this.nodes, (ImmutableList<NodeService>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeServicesResponse && this.equalTo((ImmutableNodeServicesResponse)another);
    }

    private boolean equalTo(ImmutableNodeServicesResponse another) {
        return this.nodes.equals(another.nodes) && this.services.equals(another.services);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nodes.hashCode();
        h += (h << 5) + this.services.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NodeServicesResponse").omitNullValues().add("nodes", (Object)this.nodes).add("services", this.services).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNodeServicesResponse fromJson(Json json) {
        Builder builder = ImmutableNodeServicesResponse.builder();
        if (json.nodes != null) {
            builder.setNodes(json.nodes);
        }
        if (json.services != null) {
            builder.addAllServices(json.services);
        }
        return builder.build();
    }

    public static ImmutableNodeServicesResponse copyOf(NodeServicesResponse instance) {
        if (instance instanceof ImmutableNodeServicesResponse) {
            return (ImmutableNodeServicesResponse)instance;
        }
        return ImmutableNodeServicesResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodeServicesResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODES = 1L;
        private long initBits = 1L;
        @Nullable
        private Node nodes;
        private ImmutableList.Builder<NodeService> services = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NodeServicesResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.setNodes(instance.getNodes());
            this.addAllServices(instance.getServices());
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder setNodes(Node nodes) {
            this.nodes = Objects.requireNonNull(nodes, "nodes");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServices(NodeService element) {
            this.services.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServices(NodeService ... elements) {
            this.services.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Services")
        @CanIgnoreReturnValue
        public final Builder setServices(Iterable<? extends NodeService> elements) {
            this.services = ImmutableList.builder();
            return this.addAllServices(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllServices(Iterable<? extends NodeService> elements) {
            this.services.addAll(elements);
            return this;
        }

        public ImmutableNodeServicesResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeServicesResponse(this.nodes, this.services.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nodes");
            }
            return "Cannot build NodeServicesResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NodeServicesResponse", generator="Immutables")
    static final class Json
    extends NodeServicesResponse {
        @Nullable
        Node nodes;
        @Nullable
        List<NodeService> services = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNodes(Node nodes) {
            this.nodes = nodes;
        }

        @JsonProperty(value="Services")
        public void setServices(List<NodeService> services) {
            this.services = services;
        }

        @Override
        public Node getNodes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<NodeService> getServices() {
            throw new UnsupportedOperationException();
        }
    }
}

