/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="TaggedAddresses", generator="Immutables")
@Immutable
public final class ImmutableTaggedAddresses
extends TaggedAddresses {
    @Nullable
    private final String wan;
    @Nullable
    private final String lan;

    private ImmutableTaggedAddresses(@Nullable String wan, @Nullable String lan) {
        this.wan = wan;
        this.lan = lan;
    }

    @Override
    @JsonProperty(value="wan")
    public Optional<String> getWan() {
        return Optional.ofNullable(this.wan);
    }

    @Override
    @JsonProperty(value="lan")
    public Optional<String> getLan() {
        return Optional.ofNullable(this.lan);
    }

    public final ImmutableTaggedAddresses withWan(String value) {
        String newValue = Objects.requireNonNull(value, "wan");
        if (Objects.equals(this.wan, newValue)) {
            return this;
        }
        return new ImmutableTaggedAddresses(newValue, this.lan);
    }

    public final ImmutableTaggedAddresses withWan(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.wan, value)) {
            return this;
        }
        return new ImmutableTaggedAddresses(value, this.lan);
    }

    public final ImmutableTaggedAddresses withLan(String value) {
        String newValue = Objects.requireNonNull(value, "lan");
        if (Objects.equals(this.lan, newValue)) {
            return this;
        }
        return new ImmutableTaggedAddresses(this.wan, newValue);
    }

    public final ImmutableTaggedAddresses withLan(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lan, value)) {
            return this;
        }
        return new ImmutableTaggedAddresses(this.wan, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaggedAddresses && this.equalTo((ImmutableTaggedAddresses)another);
    }

    private boolean equalTo(ImmutableTaggedAddresses another) {
        return Objects.equals(this.wan, another.wan) && Objects.equals(this.lan, another.lan);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.wan);
        h += (h << 5) + Objects.hashCode(this.lan);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaggedAddresses").omitNullValues().add("wan", (Object)this.wan).add("lan", (Object)this.lan).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTaggedAddresses fromJson(Json json) {
        Builder builder = ImmutableTaggedAddresses.builder();
        if (json.wan != null) {
            builder.setWan(json.wan);
        }
        if (json.lan != null) {
            builder.setLan(json.lan);
        }
        return builder.build();
    }

    public static ImmutableTaggedAddresses copyOf(TaggedAddresses instance) {
        if (instance instanceof ImmutableTaggedAddresses) {
            return (ImmutableTaggedAddresses)instance;
        }
        return ImmutableTaggedAddresses.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TaggedAddresses", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String wan;
        @Nullable
        private String lan;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TaggedAddresses instance) {
            Optional<String> lanOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> wanOptional = instance.getWan();
            if (wanOptional.isPresent()) {
                this.setWan(wanOptional);
            }
            if ((lanOptional = instance.getLan()).isPresent()) {
                this.setLan(lanOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setWan(String wan) {
            this.wan = Objects.requireNonNull(wan, "wan");
            return this;
        }

        @JsonProperty(value="wan")
        @CanIgnoreReturnValue
        public final Builder setWan(Optional<String> wan) {
            this.wan = wan.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setLan(String lan) {
            this.lan = Objects.requireNonNull(lan, "lan");
            return this;
        }

        @JsonProperty(value="lan")
        @CanIgnoreReturnValue
        public final Builder setLan(Optional<String> lan) {
            this.lan = lan.orElse(null);
            return this;
        }

        public ImmutableTaggedAddresses build() {
            return new ImmutableTaggedAddresses(this.wan, this.lan);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TaggedAddresses", generator="Immutables")
    static final class Json
    extends TaggedAddresses {
        @Nullable
        Optional<String> wan = Optional.empty();
        @Nullable
        Optional<String> lan = Optional.empty();

        Json() {
        }

        @JsonProperty(value="wan")
        public void setWan(Optional<String> wan) {
            this.wan = wan;
        }

        @JsonProperty(value="lan")
        public void setLan(Optional<String> lan) {
            this.lan = lan;
        }

        @Override
        public Optional<String> getWan() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLan() {
            throw new UnsupportedOperationException();
        }
    }
}

