/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.health.HealthCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="HealthCheck", generator="Immutables")
@Immutable
public final class ImmutableHealthCheck
extends HealthCheck {
    private final String node;
    private final String checkId;
    private final String name;
    private final String status;
    @Nullable
    private final String notes;
    @Nullable
    private final String output;
    @Nullable
    private final String serviceId;
    @Nullable
    private final String serviceName;
    private final ImmutableList<String> serviceTags;

    private ImmutableHealthCheck(String node, String checkId, String name, String status, @Nullable String notes, @Nullable String output, @Nullable String serviceId, @Nullable String serviceName, ImmutableList<String> serviceTags) {
        this.node = node;
        this.checkId = checkId;
        this.name = name;
        this.status = status;
        this.notes = notes;
        this.output = output;
        this.serviceId = serviceId;
        this.serviceName = serviceName;
        this.serviceTags = serviceTags;
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="CheckID")
    public String getCheckId() {
        return this.checkId;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Status")
    public String getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="Notes")
    public Optional<String> getNotes() {
        return Optional.ofNullable(this.notes);
    }

    @Override
    @JsonProperty(value="Output")
    public Optional<String> getOutput() {
        return Optional.ofNullable(this.output);
    }

    @Override
    @JsonProperty(value="ServiceID")
    public Optional<String> getServiceId() {
        return Optional.ofNullable(this.serviceId);
    }

    @Override
    @JsonProperty(value="ServiceName")
    public Optional<String> getServiceName() {
        return Optional.ofNullable(this.serviceName);
    }

    @JsonProperty(value="ServiceTags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getServiceTags() {
        return this.serviceTags;
    }

    public final ImmutableHealthCheck withNode(String value) {
        String newValue = Objects.requireNonNull(value, "node");
        if (this.node.equals(newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(newValue, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName, this.serviceTags);
    }

    public final ImmutableHealthCheck withCheckId(String value) {
        String newValue = Objects.requireNonNull(value, "checkId");
        if (this.checkId.equals(newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, newValue, this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName, this.serviceTags);
    }

    public final ImmutableHealthCheck withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, newValue, this.status, this.notes, this.output, this.serviceId, this.serviceName, this.serviceTags);
    }

    public final ImmutableHealthCheck withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals(newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, newValue, this.notes, this.output, this.serviceId, this.serviceName, this.serviceTags);
    }

    public final ImmutableHealthCheck withNotes(String value) {
        String newValue = Objects.requireNonNull(value, "notes");
        if (Objects.equals(this.notes, newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, newValue, this.output, this.serviceId, this.serviceName, this.serviceTags);
    }

    public final ImmutableHealthCheck withNotes(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.notes, value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, value, this.output, this.serviceId, this.serviceName, this.serviceTags);
    }

    public final ImmutableHealthCheck withOutput(String value) {
        String newValue = Objects.requireNonNull(value, "output");
        if (Objects.equals(this.output, newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, newValue, this.serviceId, this.serviceName, this.serviceTags);
    }

    public final ImmutableHealthCheck withOutput(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.output, value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, value, this.serviceId, this.serviceName, this.serviceTags);
    }

    public final ImmutableHealthCheck withServiceId(String value) {
        String newValue = Objects.requireNonNull(value, "serviceId");
        if (Objects.equals(this.serviceId, newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, newValue, this.serviceName, this.serviceTags);
    }

    public final ImmutableHealthCheck withServiceId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceId, value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, value, this.serviceName, this.serviceTags);
    }

    public final ImmutableHealthCheck withServiceName(String value) {
        String newValue = Objects.requireNonNull(value, "serviceName");
        if (Objects.equals(this.serviceName, newValue)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, newValue, this.serviceTags);
    }

    public final ImmutableHealthCheck withServiceName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceName, value)) {
            return this;
        }
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, value, this.serviceTags);
    }

    public final ImmutableHealthCheck withServiceTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName, (ImmutableList<String>)newValue);
    }

    public final ImmutableHealthCheck withServiceTags(Iterable<String> elements) {
        if (this.serviceTags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHealthCheck && this.equalTo((ImmutableHealthCheck)another);
    }

    private boolean equalTo(ImmutableHealthCheck another) {
        return this.node.equals(another.node) && this.checkId.equals(another.checkId) && this.name.equals(another.name) && this.status.equals(another.status) && Objects.equals(this.notes, another.notes) && Objects.equals(this.output, another.output) && Objects.equals(this.serviceId, another.serviceId) && Objects.equals(this.serviceName, another.serviceName) && this.serviceTags.equals(another.serviceTags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.checkId.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.notes);
        h += (h << 5) + Objects.hashCode(this.output);
        h += (h << 5) + Objects.hashCode(this.serviceId);
        h += (h << 5) + Objects.hashCode(this.serviceName);
        h += (h << 5) + this.serviceTags.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HealthCheck").omitNullValues().add("node", (Object)this.node).add("checkId", (Object)this.checkId).add("name", (Object)this.name).add("status", (Object)this.status).add("notes", (Object)this.notes).add("output", (Object)this.output).add("serviceId", (Object)this.serviceId).add("serviceName", (Object)this.serviceName).add("serviceTags", this.serviceTags).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHealthCheck fromJson(Json json) {
        Builder builder = ImmutableHealthCheck.builder();
        if (json.node != null) {
            builder.setNode(json.node);
        }
        if (json.checkId != null) {
            builder.setCheckId(json.checkId);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.status != null) {
            builder.setStatus(json.status);
        }
        if (json.notes != null) {
            builder.setNotes(json.notes);
        }
        if (json.output != null) {
            builder.setOutput(json.output);
        }
        if (json.serviceId != null) {
            builder.setServiceId(json.serviceId);
        }
        if (json.serviceName != null) {
            builder.setServiceName(json.serviceName);
        }
        if (json.serviceTags != null) {
            builder.addAllServiceTags(json.serviceTags);
        }
        return builder.build();
    }

    public static ImmutableHealthCheck copyOf(HealthCheck instance) {
        if (instance instanceof ImmutableHealthCheck) {
            return (ImmutableHealthCheck)instance;
        }
        return ImmutableHealthCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HealthCheck", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_CHECK_ID = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_STATUS = 8L;
        private long initBits = 15L;
        @Nullable
        private String node;
        @Nullable
        private String checkId;
        @Nullable
        private String name;
        @Nullable
        private String status;
        @Nullable
        private String notes;
        @Nullable
        private String output;
        @Nullable
        private String serviceId;
        @Nullable
        private String serviceName;
        private ImmutableList.Builder<String> serviceTags = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HealthCheck instance) {
            Optional<String> serviceNameOptional;
            Optional<String> serviceIdOptional;
            Optional<String> outputOptional;
            Objects.requireNonNull(instance, "instance");
            this.setNode(instance.getNode());
            this.setCheckId(instance.getCheckId());
            this.setName(instance.getName());
            this.setStatus(instance.getStatus());
            Optional<String> notesOptional = instance.getNotes();
            if (notesOptional.isPresent()) {
                this.setNotes(notesOptional);
            }
            if ((outputOptional = instance.getOutput()).isPresent()) {
                this.setOutput(outputOptional);
            }
            if ((serviceIdOptional = instance.getServiceId()).isPresent()) {
                this.setServiceId(serviceIdOptional);
            }
            if ((serviceNameOptional = instance.getServiceName()).isPresent()) {
                this.setServiceName(serviceNameOptional);
            }
            this.addAllServiceTags(instance.getServiceTags());
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder setNode(String node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="CheckID")
        @CanIgnoreReturnValue
        public final Builder setCheckId(String checkId) {
            this.checkId = Objects.requireNonNull(checkId, "checkId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Status")
        @CanIgnoreReturnValue
        public final Builder setStatus(String status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setNotes(String notes) {
            this.notes = Objects.requireNonNull(notes, "notes");
            return this;
        }

        @JsonProperty(value="Notes")
        @CanIgnoreReturnValue
        public final Builder setNotes(Optional<String> notes) {
            this.notes = notes.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setOutput(String output) {
            this.output = Objects.requireNonNull(output, "output");
            return this;
        }

        @JsonProperty(value="Output")
        @CanIgnoreReturnValue
        public final Builder setOutput(Optional<String> output) {
            this.output = output.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setServiceId(String serviceId) {
            this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
            return this;
        }

        @JsonProperty(value="ServiceID")
        @CanIgnoreReturnValue
        public final Builder setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setServiceName(String serviceName) {
            this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
            return this;
        }

        @JsonProperty(value="ServiceName")
        @CanIgnoreReturnValue
        public final Builder setServiceName(Optional<String> serviceName) {
            this.serviceName = serviceName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceTags(String element) {
            this.serviceTags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceTags(String ... elements) {
            this.serviceTags.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="ServiceTags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        @CanIgnoreReturnValue
        public final Builder setServiceTags(Iterable<String> elements) {
            this.serviceTags = ImmutableList.builder();
            return this.addAllServiceTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllServiceTags(Iterable<String> elements) {
            this.serviceTags.addAll(elements);
            return this;
        }

        public ImmutableHealthCheck build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, this.serviceName, this.serviceTags.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("checkId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build HealthCheck, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HealthCheck", generator="Immutables")
    static final class Json
    extends HealthCheck {
        @Nullable
        String node;
        @Nullable
        String checkId;
        @Nullable
        String name;
        @Nullable
        String status;
        @Nullable
        Optional<String> notes = Optional.empty();
        @Nullable
        Optional<String> output = Optional.empty();
        @Nullable
        Optional<String> serviceId = Optional.empty();
        @Nullable
        Optional<String> serviceName = Optional.empty();
        @Nullable
        List<String> serviceTags = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="CheckID")
        public void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="Notes")
        public void setNotes(Optional<String> notes) {
            this.notes = notes;
        }

        @JsonProperty(value="Output")
        public void setOutput(Optional<String> output) {
            this.output = output;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="ServiceName")
        public void setServiceName(Optional<String> serviceName) {
            this.serviceName = serviceName;
        }

        @JsonProperty(value="ServiceTags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setServiceTags(List<String> serviceTags) {
            this.serviceTags = serviceTags;
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCheckId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNotes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOutput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getServiceTags() {
            throw new UnsupportedOperationException();
        }
    }
}

