/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import com.orbitz.consul.model.health.Node;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Node", generator="Immutables")
@Immutable
public final class ImmutableNode
extends Node {
    @Nullable
    private final UUID id;
    private final String node;
    private final String address;
    @Nullable
    private final String datacenter;
    @Nullable
    private final TaggedAddresses taggedAddresses;
    @Nullable
    private final Map<String, String> nodeMeta;

    private ImmutableNode(@Nullable UUID id, String node, String address, @Nullable String datacenter, @Nullable TaggedAddresses taggedAddresses, @Nullable Map<String, String> nodeMeta) {
        this.id = id;
        this.node = node;
        this.address = address;
        this.datacenter = datacenter;
        this.taggedAddresses = taggedAddresses;
        this.nodeMeta = nodeMeta;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<UUID> getId() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    @JsonProperty(value="TaggedAddresses")
    public Optional<TaggedAddresses> getTaggedAddresses() {
        return Optional.ofNullable(this.taggedAddresses);
    }

    @Override
    @JsonProperty(value="Meta")
    public Optional<Map<String, String>> getNodeMeta() {
        return Optional.ofNullable(this.nodeMeta);
    }

    public final ImmutableNode withId(UUID value) {
        UUID newValue = Objects.requireNonNull(value, "id");
        if (this.id == newValue) {
            return this;
        }
        return new ImmutableNode(newValue, this.node, this.address, this.datacenter, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withId(Optional<? extends UUID> optional) {
        UUID value = optional.orElse(null);
        if (this.id == value) {
            return this;
        }
        return new ImmutableNode(value, this.node, this.address, this.datacenter, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withNode(String value) {
        String newValue = Objects.requireNonNull(value, "node");
        if (this.node.equals(newValue)) {
            return this;
        }
        return new ImmutableNode(this.id, newValue, this.address, this.datacenter, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableNode(this.id, this.node, newValue, this.datacenter, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableNode(this.id, this.node, this.address, newValue, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableNode(this.id, this.node, this.address, value, this.taggedAddresses, this.nodeMeta);
    }

    public final ImmutableNode withTaggedAddresses(TaggedAddresses value) {
        TaggedAddresses newValue = Objects.requireNonNull(value, "taggedAddresses");
        if (this.taggedAddresses == newValue) {
            return this;
        }
        return new ImmutableNode(this.id, this.node, this.address, this.datacenter, newValue, this.nodeMeta);
    }

    public final ImmutableNode withTaggedAddresses(Optional<? extends TaggedAddresses> optional) {
        TaggedAddresses value = optional.orElse(null);
        if (this.taggedAddresses == value) {
            return this;
        }
        return new ImmutableNode(this.id, this.node, this.address, this.datacenter, value, this.nodeMeta);
    }

    public final ImmutableNode withNodeMeta(Map<String, String> value) {
        Map<String, String> newValue = Objects.requireNonNull(value, "nodeMeta");
        if (this.nodeMeta == newValue) {
            return this;
        }
        return new ImmutableNode(this.id, this.node, this.address, this.datacenter, this.taggedAddresses, newValue);
    }

    public final ImmutableNode withNodeMeta(Optional<? extends Map<String, String>> optional) {
        Map value = optional.orElse(null);
        if (this.nodeMeta == value) {
            return this;
        }
        return new ImmutableNode(this.id, this.node, this.address, this.datacenter, this.taggedAddresses, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNode && this.equalTo((ImmutableNode)another);
    }

    private boolean equalTo(ImmutableNode another) {
        return Objects.equals(this.id, another.id) && this.node.equals(another.node) && this.address.equals(another.address) && Objects.equals(this.datacenter, another.datacenter) && Objects.equals(this.taggedAddresses, another.taggedAddresses) && Objects.equals(this.nodeMeta, another.nodeMeta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.address.hashCode();
        h += (h << 5) + Objects.hashCode(this.datacenter);
        h += (h << 5) + Objects.hashCode(this.taggedAddresses);
        h += (h << 5) + Objects.hashCode(this.nodeMeta);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Node").omitNullValues().add("id", (Object)this.id).add("node", (Object)this.node).add("address", (Object)this.address).add("datacenter", (Object)this.datacenter).add("taggedAddresses", (Object)this.taggedAddresses).add("nodeMeta", this.nodeMeta).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNode fromJson(Json json) {
        Builder builder = ImmutableNode.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.node != null) {
            builder.setNode(json.node);
        }
        if (json.address != null) {
            builder.setAddress(json.address);
        }
        if (json.datacenter != null) {
            builder.setDatacenter(json.datacenter);
        }
        if (json.taggedAddresses != null) {
            builder.setTaggedAddresses(json.taggedAddresses);
        }
        if (json.nodeMeta != null) {
            builder.setNodeMeta(json.nodeMeta);
        }
        return builder.build();
    }

    public static ImmutableNode copyOf(Node instance) {
        if (instance instanceof ImmutableNode) {
            return (ImmutableNode)instance;
        }
        return ImmutableNode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Node", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private long initBits = 3L;
        @Nullable
        private UUID id;
        @Nullable
        private String node;
        @Nullable
        private String address;
        @Nullable
        private String datacenter;
        @Nullable
        private TaggedAddresses taggedAddresses;
        @Nullable
        private Map<String, String> nodeMeta;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Node instance) {
            Optional<Map<String, String>> nodeMetaOptional;
            Optional<TaggedAddresses> taggedAddressesOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<UUID> idOptional = instance.getId();
            if (idOptional.isPresent()) {
                this.setId(idOptional);
            }
            this.setNode(instance.getNode());
            this.setAddress(instance.getAddress());
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.setDatacenter(datacenterOptional);
            }
            if ((taggedAddressesOptional = instance.getTaggedAddresses()).isPresent()) {
                this.setTaggedAddresses(taggedAddressesOptional);
            }
            if ((nodeMetaOptional = instance.getNodeMeta()).isPresent()) {
                this.setNodeMeta(nodeMetaOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setId(UUID id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder setId(Optional<? extends UUID> id) {
            this.id = id.orElse(null);
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder setNode(String node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Address")
        @CanIgnoreReturnValue
        public final Builder setAddress(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setDatacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @JsonProperty(value="Datacenter")
        @CanIgnoreReturnValue
        public final Builder setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setTaggedAddresses(TaggedAddresses taggedAddresses) {
            this.taggedAddresses = Objects.requireNonNull(taggedAddresses, "taggedAddresses");
            return this;
        }

        @JsonProperty(value="TaggedAddresses")
        @CanIgnoreReturnValue
        public final Builder setTaggedAddresses(Optional<? extends TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setNodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = Objects.requireNonNull(nodeMeta, "nodeMeta");
            return this;
        }

        @JsonProperty(value="Meta")
        @CanIgnoreReturnValue
        public final Builder setNodeMeta(Optional<? extends Map<String, String>> nodeMeta) {
            this.nodeMeta = nodeMeta.orElse(null);
            return this;
        }

        public ImmutableNode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNode(this.id, this.node, this.address, this.datacenter, this.taggedAddresses, this.nodeMeta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            return "Cannot build Node, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Node", generator="Immutables")
    static final class Json
    extends Node {
        @Nullable
        Optional<UUID> id = Optional.empty();
        @Nullable
        String node;
        @Nullable
        String address;
        @Nullable
        Optional<String> datacenter = Optional.empty();
        @Nullable
        Optional<TaggedAddresses> taggedAddresses = Optional.empty();
        @Nullable
        Optional<Map<String, String>> nodeMeta = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(Optional<UUID> id) {
            this.id = id;
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="TaggedAddresses")
        public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses;
        }

        @JsonProperty(value="Meta")
        public void setNodeMeta(Optional<Map<String, String>> nodeMeta) {
            this.nodeMeta = nodeMeta;
        }

        @Override
        public Optional<UUID> getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TaggedAddresses> getTaggedAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, String>> getNodeMeta() {
            throw new UnsupportedOperationException();
        }
    }
}

