/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.operator;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.operator.RaftServer;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="RaftServer", generator="Immutables")
@Immutable
public final class ImmutableRaftServer
extends RaftServer {
    private final String id;
    private final String node;
    private final String address;
    private final Boolean leader;
    private final Boolean voter;

    private ImmutableRaftServer(String id, String node, String address, Boolean leader, Boolean voter) {
        this.id = id;
        this.node = node;
        this.address = address;
        this.leader = leader;
        this.voter = voter;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Node")
    public String node() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String address() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Leader")
    public Boolean leader() {
        return this.leader;
    }

    @Override
    @JsonProperty(value="Voter")
    public Boolean voter() {
        return this.voter;
    }

    public final ImmutableRaftServer withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableRaftServer(newValue, this.node, this.address, this.leader, this.voter);
    }

    public final ImmutableRaftServer withNode(String value) {
        String newValue = Objects.requireNonNull(value, "node");
        if (this.node.equals(newValue)) {
            return this;
        }
        return new ImmutableRaftServer(this.id, newValue, this.address, this.leader, this.voter);
    }

    public final ImmutableRaftServer withAddress(String value) {
        String newValue = Objects.requireNonNull(value, "address");
        if (this.address.equals(newValue)) {
            return this;
        }
        return new ImmutableRaftServer(this.id, this.node, newValue, this.leader, this.voter);
    }

    public final ImmutableRaftServer withLeader(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "leader");
        if (this.leader.equals(newValue)) {
            return this;
        }
        return new ImmutableRaftServer(this.id, this.node, this.address, newValue, this.voter);
    }

    public final ImmutableRaftServer withVoter(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "voter");
        if (this.voter.equals(newValue)) {
            return this;
        }
        return new ImmutableRaftServer(this.id, this.node, this.address, this.leader, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRaftServer && this.equalTo((ImmutableRaftServer)another);
    }

    private boolean equalTo(ImmutableRaftServer another) {
        return this.id.equals(another.id) && this.node.equals(another.node) && this.address.equals(another.address) && this.leader.equals(another.leader) && this.voter.equals(another.voter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.address.hashCode();
        h += (h << 5) + this.leader.hashCode();
        h += (h << 5) + this.voter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RaftServer").omitNullValues().add("id", (Object)this.id).add("node", (Object)this.node).add("address", (Object)this.address).add("leader", (Object)this.leader).add("voter", (Object)this.voter).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRaftServer fromJson(Json json) {
        Builder builder = ImmutableRaftServer.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.node != null) {
            builder.setNode(json.node);
        }
        if (json.address != null) {
            builder.setAddress(json.address);
        }
        if (json.leader != null) {
            builder.setLeader(json.leader);
        }
        if (json.voter != null) {
            builder.setVoter(json.voter);
        }
        return builder.build();
    }

    public static ImmutableRaftServer copyOf(RaftServer instance) {
        if (instance instanceof ImmutableRaftServer) {
            return (ImmutableRaftServer)instance;
        }
        return ImmutableRaftServer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RaftServer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NODE = 2L;
        private static final long INIT_BIT_ADDRESS = 4L;
        private static final long INIT_BIT_LEADER = 8L;
        private static final long INIT_BIT_VOTER = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String node;
        @Nullable
        private String address;
        @Nullable
        private Boolean leader;
        @Nullable
        private Boolean voter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RaftServer instance) {
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.id());
            this.setNode(instance.node());
            this.setAddress(instance.address());
            this.setLeader(instance.leader());
            this.setVoter(instance.voter());
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder setNode(String node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Address")
        @CanIgnoreReturnValue
        public final Builder setAddress(String address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Leader")
        @CanIgnoreReturnValue
        public final Builder setLeader(Boolean leader) {
            this.leader = Objects.requireNonNull(leader, "leader");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Voter")
        @CanIgnoreReturnValue
        public final Builder setVoter(Boolean voter) {
            this.voter = Objects.requireNonNull(voter, "voter");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableRaftServer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRaftServer(this.id, this.node, this.address, this.leader, this.voter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("leader");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("voter");
            }
            return "Cannot build RaftServer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RaftServer", generator="Immutables")
    static final class Json
    extends RaftServer {
        @Nullable
        String id;
        @Nullable
        String node;
        @Nullable
        String address;
        @Nullable
        Boolean leader;
        @Nullable
        Boolean voter;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Leader")
        public void setLeader(Boolean leader) {
            this.leader = leader;
        }

        @JsonProperty(value="Voter")
        public void setVoter(Boolean voter) {
            this.voter = voter;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String node() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String address() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean leader() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean voter() {
            throw new UnsupportedOperationException();
        }
    }
}

