/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.health.HealthCheck;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.model.health.Service;
import com.orbitz.consul.model.query.DnsQuery;
import com.orbitz.consul.model.query.QueryResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="QueryResult", generator="Immutables")
@Immutable
public final class ImmutableQueryResult
extends QueryResult {
    private final Node node;
    private final Service service;
    private final ImmutableList<HealthCheck> checks;
    @Nullable
    private final DnsQuery dns;
    @Nullable
    private final String datacenters;
    @Nullable
    private final Integer failovers;

    private ImmutableQueryResult(Node node, Service service, ImmutableList<HealthCheck> checks, @Nullable DnsQuery dns, @Nullable String datacenters, @Nullable Integer failovers) {
        this.node = node;
        this.service = service;
        this.checks = checks;
        this.dns = dns;
        this.datacenters = datacenters;
        this.failovers = failovers;
    }

    @Override
    @JsonProperty(value="Node")
    public Node getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Service")
    public Service getService() {
        return this.service;
    }

    @JsonProperty(value="Checks")
    @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
    public ImmutableList<HealthCheck> getChecks() {
        return this.checks;
    }

    @Override
    @JsonProperty(value="DNS")
    public Optional<DnsQuery> getDns() {
        return Optional.ofNullable(this.dns);
    }

    @Override
    @JsonProperty(value="Datacenters")
    public Optional<String> datacenters() {
        return Optional.ofNullable(this.datacenters);
    }

    @Override
    @JsonProperty(value="Failovers")
    public Optional<Integer> failovers() {
        return Optional.ofNullable(this.failovers);
    }

    public final ImmutableQueryResult withNode(Node value) {
        if (this.node == value) {
            return this;
        }
        Node newValue = Objects.requireNonNull(value, "node");
        return new ImmutableQueryResult(newValue, this.service, this.checks, this.dns, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withService(Service value) {
        if (this.service == value) {
            return this;
        }
        Service newValue = Objects.requireNonNull(value, "service");
        return new ImmutableQueryResult(this.node, newValue, this.checks, this.dns, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withChecks(HealthCheck ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableQueryResult(this.node, this.service, (ImmutableList<HealthCheck>)newValue, this.dns, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withChecks(Iterable<? extends HealthCheck> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableQueryResult(this.node, this.service, (ImmutableList<HealthCheck>)newValue, this.dns, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withDns(DnsQuery value) {
        DnsQuery newValue = Objects.requireNonNull(value, "dns");
        if (this.dns == newValue) {
            return this;
        }
        return new ImmutableQueryResult(this.node, this.service, this.checks, newValue, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withDns(Optional<? extends DnsQuery> optional) {
        DnsQuery value = optional.orElse(null);
        if (this.dns == value) {
            return this;
        }
        return new ImmutableQueryResult(this.node, this.service, this.checks, value, this.datacenters, this.failovers);
    }

    public final ImmutableQueryResult withDatacenters(String value) {
        String newValue = Objects.requireNonNull(value, "datacenters");
        if (Objects.equals(this.datacenters, newValue)) {
            return this;
        }
        return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, newValue, this.failovers);
    }

    public final ImmutableQueryResult withDatacenters(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenters, value)) {
            return this;
        }
        return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, value, this.failovers);
    }

    public final ImmutableQueryResult withFailovers(int value) {
        Integer newValue = value;
        if (Objects.equals(this.failovers, newValue)) {
            return this;
        }
        return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, this.datacenters, newValue);
    }

    public final ImmutableQueryResult withFailovers(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.failovers, value)) {
            return this;
        }
        return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, this.datacenters, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryResult && this.equalTo((ImmutableQueryResult)another);
    }

    private boolean equalTo(ImmutableQueryResult another) {
        return this.node.equals(another.node) && this.service.equals(another.service) && this.checks.equals(another.checks) && Objects.equals(this.dns, another.dns) && Objects.equals(this.datacenters, another.datacenters) && Objects.equals(this.failovers, another.failovers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.service.hashCode();
        h += (h << 5) + this.checks.hashCode();
        h += (h << 5) + Objects.hashCode(this.dns);
        h += (h << 5) + Objects.hashCode(this.datacenters);
        h += (h << 5) + Objects.hashCode(this.failovers);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QueryResult").omitNullValues().add("node", (Object)this.node).add("service", (Object)this.service).add("checks", this.checks).add("dns", (Object)this.dns).add("datacenters", (Object)this.datacenters).add("failovers", (Object)this.failovers).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableQueryResult fromJson(Json json) {
        Builder builder = ImmutableQueryResult.builder();
        if (json.node != null) {
            builder.setNode(json.node);
        }
        if (json.service != null) {
            builder.setService(json.service);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        if (json.dns != null) {
            builder.setDns(json.dns);
        }
        if (json.datacenters != null) {
            builder.setDatacenters(json.datacenters);
        }
        if (json.failovers != null) {
            builder.setFailovers(json.failovers);
        }
        return builder.build();
    }

    public static ImmutableQueryResult copyOf(QueryResult instance) {
        if (instance instanceof ImmutableQueryResult) {
            return (ImmutableQueryResult)instance;
        }
        return ImmutableQueryResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QueryResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        @Nullable
        private Node node;
        @Nullable
        private Service service;
        private ImmutableList.Builder<HealthCheck> checks = ImmutableList.builder();
        @Nullable
        private DnsQuery dns;
        @Nullable
        private String datacenters;
        @Nullable
        private Integer failovers;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QueryResult instance) {
            Optional<Integer> failoversOptional;
            Optional<String> datacentersOptional;
            Objects.requireNonNull(instance, "instance");
            this.setNode(instance.getNode());
            this.setService(instance.getService());
            this.addAllChecks(instance.getChecks());
            Optional<DnsQuery> dnsOptional = instance.getDns();
            if (dnsOptional.isPresent()) {
                this.setDns(dnsOptional);
            }
            if ((datacentersOptional = instance.datacenters()).isPresent()) {
                this.setDatacenters(datacentersOptional);
            }
            if ((failoversOptional = instance.failovers()).isPresent()) {
                this.setFailovers(failoversOptional);
            }
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder setNode(Node node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder setService(Service service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(HealthCheck element) {
            this.checks.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(HealthCheck ... elements) {
            this.checks.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Checks")
        @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
        @CanIgnoreReturnValue
        public final Builder setChecks(Iterable<? extends HealthCheck> elements) {
            this.checks = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllChecks(Iterable<? extends HealthCheck> elements) {
            this.checks.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setDns(DnsQuery dns) {
            this.dns = Objects.requireNonNull(dns, "dns");
            return this;
        }

        @JsonProperty(value="DNS")
        @CanIgnoreReturnValue
        public final Builder setDns(Optional<? extends DnsQuery> dns) {
            this.dns = dns.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setDatacenters(String datacenters) {
            this.datacenters = Objects.requireNonNull(datacenters, "datacenters");
            return this;
        }

        @JsonProperty(value="Datacenters")
        @CanIgnoreReturnValue
        public final Builder setDatacenters(Optional<String> datacenters) {
            this.datacenters = datacenters.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setFailovers(int failovers) {
            this.failovers = failovers;
            return this;
        }

        @JsonProperty(value="Failovers")
        @CanIgnoreReturnValue
        public final Builder setFailovers(Optional<Integer> failovers) {
            this.failovers = failovers.orElse(null);
            return this;
        }

        public ImmutableQueryResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryResult(this.node, this.service, this.checks.build(), this.dns, this.datacenters, this.failovers);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build QueryResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="QueryResult", generator="Immutables")
    static final class Json
    extends QueryResult {
        @Nullable
        Node node;
        @Nullable
        Service service;
        @Nullable
        List<HealthCheck> checks = ImmutableList.of();
        @Nullable
        Optional<DnsQuery> dns = Optional.empty();
        @Nullable
        Optional<String> datacenters = Optional.empty();
        @Nullable
        Optional<Integer> failovers = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(Node node) {
            this.node = node;
        }

        @JsonProperty(value="Service")
        public void setService(Service service) {
            this.service = service;
        }

        @JsonProperty(value="Checks")
        @JsonDeserialize(as=ImmutableList.class, contentAs=HealthCheck.class)
        public void setChecks(List<HealthCheck> checks) {
            this.checks = checks;
        }

        @JsonProperty(value="DNS")
        public void setDns(Optional<DnsQuery> dns) {
            this.dns = dns;
        }

        @JsonProperty(value="Datacenters")
        public void setDatacenters(Optional<String> datacenters) {
            this.datacenters = datacenters;
        }

        @JsonProperty(value="Failovers")
        public void setFailovers(Optional<Integer> failovers) {
            this.failovers = failovers;
        }

        @Override
        public Node getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Service getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<HealthCheck> getChecks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DnsQuery> getDns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> datacenters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> failovers() {
            throw new UnsupportedOperationException();
        }
    }
}

