/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.session.Session;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Session", generator="Immutables")
@Immutable
public final class ImmutableSession
extends Session {
    @Nullable
    private final String lockDelay;
    @Nullable
    private final String name;
    @Nullable
    private final String node;
    private final ImmutableList<String> checks;
    @Nullable
    private final String behavior;
    @Nullable
    private final String ttl;

    private ImmutableSession(@Nullable String lockDelay, @Nullable String name, @Nullable String node, ImmutableList<String> checks, @Nullable String behavior, @Nullable String ttl) {
        this.lockDelay = lockDelay;
        this.name = name;
        this.node = node;
        this.checks = checks;
        this.behavior = behavior;
        this.ttl = ttl;
    }

    @Override
    @JsonProperty(value="LockDelay")
    public Optional<String> getLockDelay() {
        return Optional.ofNullable(this.lockDelay);
    }

    @Override
    @JsonProperty(value="Name")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="Node")
    public Optional<String> getNode() {
        return Optional.ofNullable(this.node);
    }

    @JsonProperty(value="Checks")
    public ImmutableList<String> getChecks() {
        return this.checks;
    }

    @Override
    @JsonProperty(value="Behavior")
    public Optional<String> getBehavior() {
        return Optional.ofNullable(this.behavior);
    }

    @Override
    @JsonProperty(value="TTL")
    public Optional<String> getTtl() {
        return Optional.ofNullable(this.ttl);
    }

    public final ImmutableSession withLockDelay(String value) {
        String newValue = Objects.requireNonNull(value, "lockDelay");
        if (Objects.equals(this.lockDelay, newValue)) {
            return this;
        }
        return new ImmutableSession(newValue, this.name, this.node, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withLockDelay(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lockDelay, value)) {
            return this;
        }
        return new ImmutableSession(value, this.name, this.node, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, newValue, this.node, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, value, this.node, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withNode(String value) {
        String newValue = Objects.requireNonNull(value, "node");
        if (Objects.equals(this.node, newValue)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, newValue, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.node, value)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, value, this.checks, this.behavior, this.ttl);
    }

    public final ImmutableSession withChecks(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSession(this.lockDelay, this.name, this.node, (ImmutableList<String>)newValue, this.behavior, this.ttl);
    }

    public final ImmutableSession withChecks(Iterable<String> elements) {
        if (this.checks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSession(this.lockDelay, this.name, this.node, (ImmutableList<String>)newValue, this.behavior, this.ttl);
    }

    public final ImmutableSession withBehavior(String value) {
        String newValue = Objects.requireNonNull(value, "behavior");
        if (Objects.equals(this.behavior, newValue)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, newValue, this.ttl);
    }

    public final ImmutableSession withBehavior(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.behavior, value)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, value, this.ttl);
    }

    public final ImmutableSession withTtl(String value) {
        String newValue = Objects.requireNonNull(value, "ttl");
        if (Objects.equals(this.ttl, newValue)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, this.behavior, newValue);
    }

    public final ImmutableSession withTtl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ttl, value)) {
            return this;
        }
        return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks, this.behavior, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSession && this.equalTo((ImmutableSession)another);
    }

    private boolean equalTo(ImmutableSession another) {
        return Objects.equals(this.lockDelay, another.lockDelay) && Objects.equals(this.name, another.name) && Objects.equals(this.node, another.node) && this.checks.equals(another.checks) && Objects.equals(this.behavior, another.behavior) && Objects.equals(this.ttl, another.ttl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.lockDelay);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.node);
        h += (h << 5) + this.checks.hashCode();
        h += (h << 5) + Objects.hashCode(this.behavior);
        h += (h << 5) + Objects.hashCode(this.ttl);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Session").omitNullValues().add("lockDelay", (Object)this.lockDelay).add("name", (Object)this.name).add("node", (Object)this.node).add("checks", this.checks).add("behavior", (Object)this.behavior).add("ttl", (Object)this.ttl).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSession fromJson(Json json) {
        Builder builder = ImmutableSession.builder();
        if (json.lockDelay != null) {
            builder.setLockDelay(json.lockDelay);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.node != null) {
            builder.setNode(json.node);
        }
        if (json.checks != null) {
            builder.addAllChecks(json.checks);
        }
        if (json.behavior != null) {
            builder.setBehavior(json.behavior);
        }
        if (json.ttl != null) {
            builder.setTtl(json.ttl);
        }
        return builder.build();
    }

    public static ImmutableSession copyOf(Session instance) {
        if (instance instanceof ImmutableSession) {
            return (ImmutableSession)instance;
        }
        return ImmutableSession.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Session", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String lockDelay;
        @Nullable
        private String name;
        @Nullable
        private String node;
        private ImmutableList.Builder<String> checks = ImmutableList.builder();
        @Nullable
        private String behavior;
        @Nullable
        private String ttl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Session instance) {
            Optional<String> ttlOptional;
            Optional<String> nodeOptional;
            Optional<String> nameOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> lockDelayOptional = instance.getLockDelay();
            if (lockDelayOptional.isPresent()) {
                this.setLockDelay(lockDelayOptional);
            }
            if ((nameOptional = instance.getName()).isPresent()) {
                this.setName(nameOptional);
            }
            if ((nodeOptional = instance.getNode()).isPresent()) {
                this.setNode(nodeOptional);
            }
            this.addAllChecks(instance.getChecks());
            Optional<String> behaviorOptional = instance.getBehavior();
            if (behaviorOptional.isPresent()) {
                this.setBehavior(behaviorOptional);
            }
            if ((ttlOptional = instance.getTtl()).isPresent()) {
                this.setTtl(ttlOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setLockDelay(String lockDelay) {
            this.lockDelay = Objects.requireNonNull(lockDelay, "lockDelay");
            return this;
        }

        @JsonProperty(value="LockDelay")
        @CanIgnoreReturnValue
        public final Builder setLockDelay(Optional<String> lockDelay) {
            this.lockDelay = lockDelay.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder setName(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setNode(String node) {
            this.node = Objects.requireNonNull(node, "node");
            return this;
        }

        @JsonProperty(value="Node")
        @CanIgnoreReturnValue
        public final Builder setNode(Optional<String> node) {
            this.node = node.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(String element) {
            this.checks.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChecks(String ... elements) {
            this.checks.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Checks")
        @CanIgnoreReturnValue
        public final Builder setChecks(Iterable<String> elements) {
            this.checks = ImmutableList.builder();
            return this.addAllChecks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllChecks(Iterable<String> elements) {
            this.checks.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setBehavior(String behavior) {
            this.behavior = Objects.requireNonNull(behavior, "behavior");
            return this;
        }

        @JsonProperty(value="Behavior")
        @CanIgnoreReturnValue
        public final Builder setBehavior(Optional<String> behavior) {
            this.behavior = behavior.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setTtl(String ttl) {
            this.ttl = Objects.requireNonNull(ttl, "ttl");
            return this;
        }

        @JsonProperty(value="TTL")
        @CanIgnoreReturnValue
        public final Builder setTtl(Optional<String> ttl) {
            this.ttl = ttl.orElse(null);
            return this;
        }

        public ImmutableSession build() {
            return new ImmutableSession(this.lockDelay, this.name, this.node, this.checks.build(), this.behavior, this.ttl);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Session", generator="Immutables")
    static final class Json
    extends Session {
        @Nullable
        Optional<String> lockDelay = Optional.empty();
        @Nullable
        Optional<String> name = Optional.empty();
        @Nullable
        Optional<String> node = Optional.empty();
        @Nullable
        List<String> checks = ImmutableList.of();
        @Nullable
        Optional<String> behavior = Optional.empty();
        @Nullable
        Optional<String> ttl = Optional.empty();

        Json() {
        }

        @JsonProperty(value="LockDelay")
        public void setLockDelay(Optional<String> lockDelay) {
            this.lockDelay = lockDelay;
        }

        @JsonProperty(value="Name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="Node")
        public void setNode(Optional<String> node) {
            this.node = node;
        }

        @JsonProperty(value="Checks")
        public void setChecks(List<String> checks) {
            this.checks = checks;
        }

        @JsonProperty(value="Behavior")
        public void setBehavior(Optional<String> behavior) {
            this.behavior = behavior;
        }

        @JsonProperty(value="TTL")
        public void setTtl(Optional<String> ttl) {
            this.ttl = ttl;
        }

        @Override
        public Optional<String> getLockDelay() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getChecks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBehavior() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTtl() {
            throw new UnsupportedOperationException();
        }
    }
}

