/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.util;

import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.model.session.ImmutableSession;
import java.util.Optional;

public class LeaderElectionUtil {
    private final Consul client;

    public LeaderElectionUtil(Consul client) {
        this.client = client;
    }

    public Optional<String> getLeaderInfoForService(String serviceName) {
        String key = LeaderElectionUtil.getServiceKey(serviceName);
        Optional<Value> value = this.client.keyValueClient().getValue(key);
        return value.flatMap(val -> {
            if (val.getSession().isPresent()) {
                return val.getValueAsString();
            }
            return Optional.empty();
        });
    }

    public Optional<String> electNewLeaderForService(String serviceName, String info) {
        String key = LeaderElectionUtil.getServiceKey(serviceName);
        String sessionId = this.createSession(serviceName);
        if (this.client.keyValueClient().acquireLock(key, info, sessionId)) {
            return Optional.of(info);
        }
        return this.getLeaderInfoForService(serviceName);
    }

    public boolean releaseLockForService(String serviceName) {
        String key = LeaderElectionUtil.getServiceKey(serviceName);
        KeyValueClient kv = this.client.keyValueClient();
        Optional<Value> value = kv.getValue(key);
        if (value.isPresent() && value.get().getSession().isPresent()) {
            return kv.releaseLock(key, value.get().getSession().get());
        }
        return true;
    }

    private String createSession(String serviceName) {
        ImmutableSession session = ImmutableSession.builder().setName(serviceName).build();
        return this.client.sessionClient().createSession(session).getId();
    }

    private static String getServiceKey(String serviceName) {
        return "service/" + serviceName + "/leader";
    }
}

