/*
 * Fabric3
 * Copyright (c) 2009-2015 Metaform Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * Portions originally based on Apache Tuscany 2007
 * licensed under the Apache 2.0 license.
 */
package org.fabric3.contribution.scanner.spi;

import java.io.File;

/**
 * Creates {@link FileSystemResource}s for a deployable artifact.
 */
public interface FileSystemResourceFactory {

    /**
     * Creates a {@link FileSystemResource} or returns null if this factory does not create resources for the given artifact type.
     *
     * @param file the file to create the resource for or null
     * @return the deployment artifact
     */
    FileSystemResource createResource(File file);

}
