/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.scanner.impl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.FileContributionSource;
import org.fabric3.api.host.contribution.ValidationException;
import org.fabric3.api.host.domain.AssemblyException;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.contribution.scanner.impl.ScannerMonitor;
import org.fabric3.contribution.scanner.spi.FileSystemResource;
import org.fabric3.contribution.scanner.spi.FileSystemResourceFactoryRegistry;
import org.fabric3.contribution.scanner.spi.FileSystemResourceState;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.ExtensionsInitialized;
import org.fabric3.spi.runtime.event.Fabric3Event;
import org.fabric3.spi.runtime.event.Fabric3EventListener;
import org.fabric3.spi.runtime.event.RuntimeStart;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ContributionDirectoryScanner
implements Runnable,
Fabric3EventListener {
    private ContributionService contributionService;
    private FileSystemResourceFactoryRegistry registry;
    private EventService eventService;
    private ScannerMonitor monitor;
    private Domain domain;
    private List<File> paths;
    private long delay = 2000L;
    private boolean production = false;
    private ScheduledExecutorService executor;
    private Set<File> ignored = new HashSet<File>();
    private Map<String, FileSystemResource> cache = new HashMap<String, FileSystemResource>();
    List<URI> notSeen = new ArrayList<URI>();
    private Set<String> tracked = new HashSet<String>();

    public ContributionDirectoryScanner(@Reference ContributionService contributionService, @Reference(name="assembly") Domain domain, @Reference FileSystemResourceFactoryRegistry registry, @Reference EventService eventService, @Reference HostInfo hostInfo, @Monitor ScannerMonitor monitor) {
        this.registry = registry;
        this.contributionService = contributionService;
        this.domain = domain;
        this.eventService = eventService;
        this.paths = hostInfo.getDeployDirectories();
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setProduction(boolean production) {
        this.production = production;
    }

    @Property(required=false)
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Init
    public void init() {
        this.eventService.subscribe(ExtensionsInitialized.class, (Fabric3EventListener)this);
        this.eventService.subscribe(RuntimeStart.class, (Fabric3EventListener)this);
    }

    @Destroy
    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void onEvent(Fabric3Event event) {
        if (event instanceof ExtensionsInitialized) {
            if (this.paths == null) {
                return;
            }
            ArrayList<File> files = new ArrayList<File>();
            for (File path : this.paths) {
                File[] pathFiles = path.listFiles();
                if (pathFiles == null) continue;
                Collections.addAll(files, pathFiles);
            }
            this.processFiles(files, true);
        } else if (event instanceof RuntimeStart) {
            try {
                this.domain.include(this.notSeen);
            }
            catch (Fabric3Exception e) {
                this.monitor.error(e);
            }
            this.notSeen.clear();
            if (!this.production) {
                this.executor = Executors.newSingleThreadScheduledExecutor();
                this.executor.scheduleWithFixedDelay(this, 10L, this.delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public synchronized void run() {
        if (this.paths == null) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File path : this.paths) {
            File[] pathFiles;
            if (!path.isDirectory() || (pathFiles = path.listFiles()) == null) continue;
            Collections.addAll(files, pathFiles);
        }
        this.processRemovals(files);
        if (files.isEmpty()) {
            return;
        }
        try {
            this.processFiles(files, false);
            this.processIgnored();
        }
        catch (RuntimeException e) {
            this.monitor.error(e);
        }
        catch (Error e) {
            this.monitor.error(e);
            throw e;
        }
    }

    private synchronized void processFiles(List<File> files, boolean recover) {
        for (File file : files) {
            String name = file.getName();
            FileSystemResource cached = this.cache.get(name);
            if (cached == null) {
                cached = this.registry.createResource(file);
                if (cached == null) {
                    if (!(name.startsWith(".") || name.endsWith(".txt") || this.ignored.contains(file))) {
                        this.monitor.ignored(name);
                    }
                    this.ignored.add(file);
                    continue;
                }
                this.cache.put(name, cached);
                if (recover) {
                    cached.setState(FileSystemResourceState.ADDED);
                    continue;
                }
                this.ignored.remove(file);
                continue;
            }
            if (cached.getState() == FileSystemResourceState.ERROR) {
                if (!cached.isChanged()) continue;
                cached.setState(FileSystemResourceState.DETECTED);
                cached.checkpoint();
                continue;
            }
            if (cached.getState() == FileSystemResourceState.DETECTED) {
                if (cached.isChanged()) continue;
                cached.setState(FileSystemResourceState.ADDED);
                cached.checkpoint();
                continue;
            }
            if (cached.getState() != FileSystemResourceState.PROCESSED || !cached.isChanged()) continue;
            cached.setState(FileSystemResourceState.UPDATED);
            cached.checkpoint();
        }
        if (recover) {
            this.processAdditions(true);
        } else {
            this.processUpdates();
            this.processAdditions(false);
        }
    }

    private synchronized void processUpdates() {
        ArrayList sources = new ArrayList();
        ArrayList updatedResources = new ArrayList();
        ArrayList uris = new ArrayList();
        HashSet undeployed = new HashSet();
        for (FileSystemResource resource : this.cache.values()) {
            if (resource.getState() != FileSystemResourceState.UPDATED) continue;
            try {
                String name = resource.getName();
                URI artifactUri = new URI(name);
                URL location = resource.getLocation();
                long timestamp = resource.getTimestamp();
                List affected = this.contributionService.getContributionAndDependents(artifactUri);
                affected.forEach(contribution -> {
                    if (undeployed.contains(contribution)) {
                        return;
                    }
                    try {
                        this.domain.undeploy(contribution);
                    }
                    catch (Fabric3Exception e) {
                        this.monitor.error(e);
                        return;
                    }
                    undeployed.add(contribution);
                    FileContributionSource source = new FileContributionSource(contribution, location, timestamp, false);
                    sources.add(source);
                    updatedResources.add(resource);
                    uris.add(contribution);
                });
            }
            catch (URISyntaxException e) {
                resource.setState(FileSystemResourceState.ERROR);
                this.monitor.error(e);
            }
        }
        try {
            if (!uris.isEmpty()) {
                this.contributionService.uninstall(uris);
                this.contributionService.remove(uris);
            }
            if (!sources.isEmpty()) {
                List stored = this.contributionService.store(sources);
                List contributions = this.contributionService.install(stored);
                this.domain.include(contributions);
                for (FileSystemResource resource : updatedResources) {
                    resource.setState(FileSystemResourceState.PROCESSED);
                    resource.checkpoint();
                    this.monitor.processed(resource.getName());
                }
            }
        }
        catch (Fabric3Exception e) {
            for (FileSystemResource resource : updatedResources) {
                resource.setState(FileSystemResourceState.ERROR);
            }
            this.monitor.error(e);
        }
    }

    private synchronized void processAdditions(boolean recover) {
        ArrayList<FileContributionSource> sources = new ArrayList<FileContributionSource>();
        ArrayList<FileSystemResource> addedResources = new ArrayList<FileSystemResource>();
        for (FileSystemResource resource : this.cache.values()) {
            if (resource.getState() != FileSystemResourceState.ADDED || resource.isChanged()) {
                resource.checkpoint();
                continue;
            }
            String string = resource.getName();
            URL location = resource.getLocation();
            long timestamp = resource.getTimestamp();
            URI uri = URI.create(string);
            FileContributionSource source = new FileContributionSource(uri, location, timestamp, false);
            sources.add(source);
            addedResources.add(resource);
            boolean seen = this.tracked.contains(string);
            if (!seen && recover) {
                this.notSeen.add(uri);
            }
            this.tracked.add(string);
        }
        if (!sources.isEmpty()) {
            try {
                List stored = this.contributionService.store(sources);
                List addedUris = this.contributionService.install(stored);
                if (!recover) {
                    this.domain.include(addedUris);
                }
                for (FileSystemResource resource : addedResources) {
                    resource.setState(FileSystemResourceState.PROCESSED);
                    resource.checkpoint();
                    this.monitor.processed(resource.getName());
                }
            }
            catch (ValidationException e) {
                for (ContributionSource contributionSource : sources) {
                    this.notSeen.remove(contributionSource.getUri());
                }
                this.monitor.contributionErrors(e.getMessage());
                for (FileSystemResource fileSystemResource : addedResources) {
                    fileSystemResource.setState(FileSystemResourceState.ERROR);
                }
            }
            catch (AssemblyException e) {
                this.monitor.deploymentErrors(e.getMessage());
                for (FileSystemResource fileSystemResource : addedResources) {
                    fileSystemResource.setState(FileSystemResourceState.ERROR);
                }
            }
            catch (NoClassDefFoundError | Fabric3Exception e) {
                this.handleError(e, addedResources);
            }
            catch (Error | RuntimeException e) {
                for (FileSystemResource fileSystemResource : addedResources) {
                    fileSystemResource.setState(FileSystemResourceState.ERROR);
                }
                throw e;
            }
        }
    }

    private synchronized void processRemovals(List<File> files) {
        HashMap<String, File> index = new HashMap<String, File>(files.size());
        for (File file : files) {
            index.put(file.getName(), file);
        }
        Iterator<FileSystemResource> iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            FileSystemResource entry = iterator.next();
            String name = entry.getName();
            URI uri = URI.create(name);
            if (index.get(name) != null) continue;
            try {
                this.tracked.remove(name);
                iterator.remove();
                if (this.contributionService.exists(uri)) {
                    this.domain.undeploy(uri);
                    this.contributionService.uninstall(uri);
                    this.contributionService.remove(uri);
                }
                this.monitor.removed(name);
            }
            catch (Fabric3Exception e) {
                this.monitor.removalError(name, e);
            }
        }
    }

    private synchronized void processIgnored() {
        Iterator<File> iter = this.ignored.iterator();
        while (iter.hasNext()) {
            File file = iter.next();
            if (file.exists()) continue;
            iter.remove();
        }
    }

    private void handleError(Throwable e, List<FileSystemResource> addedResources) {
        this.monitor.error(e);
        for (FileSystemResource resource : addedResources) {
            resource.setState(FileSystemResourceState.ERROR);
        }
    }
}

