/*
 * Fabric3
 * Copyright (c) 2009-2015 Metaform Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * Portions originally based on Apache Tuscany 2007
 * licensed under the Apache 2.0 license.
 */
package org.fabric3.runtime.maven.test;

import java.util.Map;

import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.oasisopen.sca.annotation.Reference;

import org.fabric3.runtime.maven.TestSuiteFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.test.spi.TestWireHolder;

/**
 *
 */
public class TestSuiteFactoryImpl implements TestSuiteFactory {
    private TestWireHolder holder;

    public TestSuiteFactoryImpl(@Reference TestWireHolder holder) {
        this.holder = holder;
    }

    public SurefireTestSuite createTestSuite(boolean ignoreTestFailures) {
        // get wires to test operations generated by test extensions
        SCATestSuite suite = new SCATestSuite();
        for (Map.Entry<String, Wire> entry : holder.getWires().entrySet()) {
            SCATestSet testSet = new SCATestSet(entry.getKey(), entry.getValue(), ignoreTestFailures);
            suite.add(testSet);
        }
        return suite;

    }
}
