/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.maven.test;

import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.testset.SurefireTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageCache;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;

public class SCATestSet
implements SurefireTestSet {
    private final String name;
    private Wire wire;
    private boolean ignoreTestFailures;

    public SCATestSet(String name, Wire wire, boolean ignoreTestFailures) {
        this.name = name;
        this.wire = wire;
        this.ignoreTestFailures = ignoreTestFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ReporterManager reporterManager, ClassLoader loader) throws TestSetFailedException {
        Message message = MessageCache.getAndResetMessage();
        WorkContext workContext = WorkContextCache.getAndResetThreadWorkContext();
        for (InvocationChain chain : this.wire.getInvocationChains()) {
            String operationName = chain.getPhysicalOperation().getName();
            reporterManager.testStarting(new ReportEntry((Object)this, operationName, this.name));
            try {
                message.setWorkContext(workContext);
                Message response = chain.getHeadInterceptor().invoke(message);
                if (response.isFault()) {
                    throw new TestSetFailedException(operationName, (Throwable)response.getBody());
                }
                reporterManager.testSucceeded(new ReportEntry((Object)this, operationName, this.name));
            }
            catch (TestSetFailedException e) {
                PojoStackTraceWriter stw = new PojoStackTraceWriter(this.name, operationName, e.getCause());
                reporterManager.testFailed(new ReportEntry((Object)this, operationName, this.name, (StackTraceWriter)stw));
                if (this.ignoreTestFailures) continue;
                throw e;
            }
            finally {
                message.reset();
                workContext.reset();
            }
        }
    }

    public int getTestCount() {
        return this.wire.getInvocationChains().size();
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getTestClass() {
        throw new UnsupportedOperationException();
    }
}

