/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.maven.test;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.ReporterManagerFactory;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.fabric3.runtime.maven.test.SCATestSet;

public class SCATestSuite
implements SurefireTestSuite {
    private final Map<String, SCATestSet> testSets = new HashMap<String, SCATestSet>();
    private int testSetCount = 0;
    private int testCount = 0;

    public void add(SCATestSet testSet) {
        this.testSets.put(testSet.getName(), testSet);
        ++this.testSetCount;
        this.testCount += testSet.getTestCount();
    }

    public void execute(ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        ReporterManager reporterManager = reporterManagerFactory.createReporterManager();
        for (SCATestSet testSet : this.testSets.values()) {
            this.execute(testSet, reporterManager, classLoader);
        }
    }

    public void execute(String testSetName, ReporterManagerFactory reporterManagerFactory, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        ReporterManager reporterManager = reporterManagerFactory.createReporterManager();
        for (SCATestSet testSet : this.testSets.values()) {
            this.execute(testSet, reporterManager, classLoader);
        }
    }

    public int getNumTests() {
        return this.testCount;
    }

    public int getNumTestSets() {
        return this.testSetCount;
    }

    protected void execute(SCATestSet testSet, ReporterManager reporterManager, ClassLoader classLoader) throws ReporterException, TestSetFailedException {
        reporterManager.testSetStarting(new ReportEntry((Object)this, testSet.getName(), "Starting"));
        testSet.execute(reporterManager, classLoader);
        reporterManager.testSetCompleted(new ReportEntry((Object)this, testSet.getName(), "Completed"));
        reporterManager.reset();
    }

    public Map<?, ?> locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        throw new UnsupportedOperationException();
    }
}

