/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.node;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.fabric3.api.node.Fabric;
import org.fabric3.api.node.FabricException;

public class Bootstrap {
    private static final String FABRIC_CLASS = "org.fabric3.node.DefaultFabric";
    private static Fabric CACHED;

    public static Fabric initialize() throws FabricException {
        return Bootstrap.boot(null);
    }

    public static Fabric initialize(URL url) throws FabricException {
        if (url == null) {
            throw new IllegalArgumentException("Configuration URL is null");
        }
        return Bootstrap.boot(url);
    }

    private static Fabric boot(URL url) throws FabricException {
        if (CACHED != null) {
            return CACHED;
        }
        try {
            ClassLoader bootstrapClassLoader = Bootstrap.class.getClassLoader();
            Class<?> implClass = Class.forName(FABRIC_CLASS, true, bootstrapClassLoader);
            return (Fabric)implClass.getConstructor(URL.class).newInstance(url);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new FabricException(e);
        }
        catch (InvocationTargetException e) {
            throw new FabricException(e.getTargetException());
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }
}

