/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import org.fabric3.api.host.util.CompositeEnumeration;

public class DelegatingResourceClassLoader
extends URLClassLoader {
    public DelegatingResourceClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.checkParent(parent);
    }

    public DelegatingResourceClassLoader(URL[] urls) {
        this(urls, null);
    }

    public DelegatingResourceClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.checkParent(parent);
    }

    @Override
    public URL getResource(String name) {
        URL url = this.getParent().getResource(name);
        return url == null ? this.findResource(name) : url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] resources = new Enumeration[]{this.getParent().getResources(name), this.findResources(name)};
        return new CompositeEnumeration<URL>(resources);
    }

    private void checkParent(ClassLoader parent) {
        if (parent == null) {
            throw new UnsupportedOperationException("This classloader cannot be used as a top-level classloader");
        }
    }
}

