/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MaskingClassLoader
extends ClassLoader {
    private static final Enumeration<URL> EMPTY = new Enumeration<URL>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            throw new NoSuchElementException();
        }
    };
    private String[] packageMasks;
    private boolean maskResources;

    public MaskingClassLoader(ClassLoader parent, String ... packageMasks) {
        this(parent, packageMasks, false);
    }

    public MaskingClassLoader(ClassLoader parent, String[] packageMasks, boolean maskResources) {
        super(parent);
        this.packageMasks = packageMasks;
        this.maskResources = maskResources;
    }

    @Override
    public URL getResource(String name) {
        if (this.maskResources) {
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.maskResources) {
            return EMPTY;
        }
        return super.getResources(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String mask : this.packageMasks) {
            if (!name.startsWith(mask)) continue;
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected URL findResource(String name) {
        if (this.maskResources) {
            return null;
        }
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (this.maskResources) {
            return EMPTY;
        }
        return super.findResources(name);
    }
}

