/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.classloader;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class ResourceFilter {
    private String[] resourceMasks;

    public ResourceFilter(String[] resourceMasks) {
        this.resourceMasks = resourceMasks;
    }

    public URL filterResource(URL url) {
        if (url == null || this.resourceMasks.length == 0) {
            return url;
        }
        String str = url.toString();
        for (String mask : this.resourceMasks) {
            if (!str.contains(mask)) continue;
            return null;
        }
        return url;
    }

    public Enumeration<URL> filterResources(Enumeration<URL> enumeration) {
        if (this.resourceMasks == null || enumeration == null || this.resourceMasks.length == 0) {
            return enumeration;
        }
        ArrayList<URL> resources = Collections.list(enumeration);
        ArrayList<URL> maskedResources = new ArrayList<URL>(resources.size());
        for (URL resource : resources) {
            String str = resource.toString();
            boolean toInclude = true;
            for (String mask : this.resourceMasks) {
                if (!str.contains(mask)) continue;
                toInclude = false;
                break;
            }
            if (!toInclude) continue;
            maskedResources.add(resource);
        }
        return Collections.enumeration(maskedResources);
    }
}

