/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.contribution;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.host.failure.ValidationUtils;

public class ValidationException
extends Fabric3Exception {
    private static final long serialVersionUID = -9097590343387033730L;
    private final List<ValidationFailure> errors;
    private final List<ValidationFailure> warnings;

    public ValidationException(List<ValidationFailure> errors, List<ValidationFailure> warnings) {
        super("Validation errors were found");
        this.errors = errors;
        this.warnings = warnings;
    }

    public ValidationException(String message, List<ValidationFailure> errors, List<ValidationFailure> warnings) {
        super(message);
        this.errors = errors;
        this.warnings = warnings;
    }

    public List<ValidationFailure> getErrors() {
        return this.errors;
    }

    public List<ValidationFailure> getWarnings() {
        return this.warnings;
    }

    @Override
    public String getMessage() {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bas);
        ValidationUtils.writeErrors(writer, this.errors);
        writer.write("\n");
        ValidationUtils.writeWarnings(writer, this.warnings);
        return bas.toString();
    }
}

