/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.domain;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.failure.AssemblyFailure;

public class AssemblyException
extends Fabric3Exception {
    private static final long serialVersionUID = 3957908169593535300L;
    private static final Comparator<AssemblyFailure> COMPARATOR = (first, second) -> first.getComponentUri().compareTo(second.getComponentUri());
    private final transient List<AssemblyFailure> errors;

    public AssemblyException(List<AssemblyFailure> errors) {
        this.errors = errors;
    }

    public List<AssemblyFailure> getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bas);
        if (!this.errors.isEmpty()) {
            ArrayList<AssemblyFailure> sorted = new ArrayList<AssemblyFailure>(this.errors);
            Collections.sort(sorted, COMPARATOR);
            for (AssemblyFailure error : sorted) {
                writer.write(error.getMessage() + " (" + error.getContributionUri() + ")");
                writer.write("\n\n");
            }
        }
        writer.flush();
        return bas.toString();
    }
}

