/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.failure;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.fabric3.api.host.contribution.ArtifactValidationFailure;
import org.fabric3.api.host.failure.Failure;
import org.fabric3.api.host.failure.ValidationFailure;

public final class ValidationUtils {
    private static Comparator<Failure> COMPARATOR = (first, second) -> {
        if (first instanceof Failure && !(second instanceof Failure)) {
            return -1;
        }
        if (!(first instanceof Failure) && second instanceof Failure) {
            return 1;
        }
        return 0;
    };

    private ValidationUtils() {
    }

    public static String outputErrors(List<? extends Failure> failures) {
        return ValidationUtils.output(failures, TYPE.ERROR);
    }

    public static String outputWarnings(List<? extends Failure> failures) {
        return ValidationUtils.output(failures, TYPE.WARNING);
    }

    public static void writeErrors(PrintWriter writer, List<? extends Failure> failures) {
        ValidationUtils.write(writer, failures, TYPE.ERROR);
    }

    public static void writeWarnings(PrintWriter writer, List<? extends Failure> failures) {
        ValidationUtils.write(writer, failures, TYPE.WARNING);
    }

    private static String output(List<? extends Failure> failures, TYPE type) {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bas);
        ValidationUtils.write(writer, failures, type);
        return bas.toString();
    }

    private static void write(PrintWriter writer, List<? extends Failure> failures, TYPE type) {
        int count = 0;
        ArrayList<? extends Failure> sorted = new ArrayList<Failure>(failures);
        Collections.sort(sorted, COMPARATOR);
        HashSet<String> reported = new HashSet<String>();
        for (Failure failure : sorted) {
            count = ValidationUtils.writerError(failure, writer, count, type, reported);
        }
        if (count == 1) {
            if (type == TYPE.ERROR) {
                writer.write("1 error was found \n\n");
            } else {
                writer.write("1 warning was found \n\n");
            }
        } else if (type == TYPE.ERROR) {
            writer.write(count + " errors were found \n\n");
        } else if (count != 0) {
            writer.write(count + " warnings were found \n\n");
        }
        writer.flush();
    }

    private static int writerError(Failure failure, PrintWriter writer, int count, TYPE type, HashSet<String> reported) {
        if (failure instanceof ArtifactValidationFailure) {
            ArtifactValidationFailure artifactFailure = (ArtifactValidationFailure)failure;
            if (reported.contains(artifactFailure.getArtifactName())) {
                return count;
            }
            if (!ValidationUtils.errorsOnlyInContainedArtifacts(artifactFailure)) {
                if (type == TYPE.ERROR) {
                    writer.write("Errors in " + artifactFailure.getArtifactName() + " (" + artifactFailure.getContributionUri() + ")\n\n");
                } else {
                    writer.write("Warnings in " + artifactFailure.getArtifactName() + " (" + artifactFailure.getContributionUri() + ")\n\n");
                }
            }
            for (ValidationFailure childFailure : artifactFailure.getFailures()) {
                count = ValidationUtils.writerError(childFailure, writer, count, type, reported);
            }
            reported.add(artifactFailure.getArtifactName());
        } else {
            if (type == TYPE.ERROR) {
                writer.write("  ERROR: " + failure.getMessage() + "\n\n");
            } else {
                writer.write("  WARNING: " + failure.getMessage() + "\n\n");
            }
            ++count;
        }
        return count;
    }

    private static boolean errorsOnlyInContainedArtifacts(ArtifactValidationFailure artifactFailure) {
        for (ValidationFailure failure : artifactFailure.getFailures()) {
            if (failure instanceof ArtifactValidationFailure) continue;
            return false;
        }
        return true;
    }

    private static enum TYPE {
        WARNING,
        ERROR;

    }
}

