/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.monitor;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.host.monitor.DestinationRouter;
import org.fabric3.api.host.monitor.MessageFormatter;
import org.oasisopen.sca.annotation.Reference;

public class DelegatingDestinationRouter
implements DestinationRouter {
    public static final String BOOT_FORMAT = "MM:dd:yyyy HH:mm:ss.SSS";
    private DestinationRouter delegate;
    private List<Entry> cache = new ArrayList<Entry>();

    @Reference(required=false)
    public void setDestination(DestinationRouter destination) {
        this.delegate = destination;
        for (Entry entry : this.cache) {
            this.delegate.send(entry.level, entry.destinationIndex, entry.timestamp, entry.source, entry.message, entry.parse, entry.values);
        }
        this.cache = null;
    }

    public void flush(OutputStream stream) {
        if (this.cache != null) {
            SimpleDateFormat format = new SimpleDateFormat(BOOT_FORMAT);
            for (Entry entry : this.cache) {
                this.write(entry.level, entry.timestamp, entry.message, entry.values, stream, format);
            }
            this.cache.clear();
        }
    }

    @Override
    public int getDestinationIndex(String name) {
        if (this.delegate == null) {
            if ("default".equals(name)) {
                return 0;
            }
            return -1;
        }
        return this.delegate.getDestinationIndex(name);
    }

    @Override
    public void send(MonitorLevel level, int destinationIndex, long timestamp, String source, String message, boolean parse, Object ... args) {
        if (this.delegate != null) {
            this.delegate.send(level, destinationIndex, timestamp, source, message, parse, args);
        } else {
            this.cache.add(new Entry(level, destinationIndex, timestamp, source, message, parse, args));
        }
    }

    private void write(MonitorLevel level, long timestamp, String message, Object[] args, OutputStream stream, DateFormat format) {
        message = MessageFormatter.format(message, args);
        Throwable e = null;
        for (Object o : args) {
            if (!(o instanceof Throwable)) continue;
            e = (Throwable)o;
        }
        if (e != null) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            if (message != null) {
                writer.write(message);
            }
            writer.write("\n");
            e.printStackTrace(pw);
            message = writer.toString();
        }
        byte[] bytes = ("[" + (Object)((Object)level) + " " + format.format(new Date(timestamp)) + "] " + message + "\n").getBytes();
        try {
            stream.write(bytes);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private class Entry {
        protected MonitorLevel level;
        private int destinationIndex;
        protected long timestamp;
        private String source;
        protected String message;
        private boolean parse;
        protected Object[] values;

        private Entry(MonitorLevel level, int destinationIndex, long timestamp, String source, String message, boolean parse, Object ... values) {
            this.level = level;
            this.destinationIndex = destinationIndex;
            this.timestamp = timestamp;
            this.source = source;
            this.message = message;
            this.parse = parse;
            this.values = values;
        }
    }
}

