/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.runtime;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.Version;
import org.fabric3.api.host.classloader.DelegatingResourceClassLoader;
import org.fabric3.api.host.os.OperatingSystem;
import org.fabric3.api.host.runtime.DefaultHostInfoBuilder;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.util.FileHelper;
import org.fabric3.api.host.util.OSHelper;
import org.fabric3.api.model.type.RuntimeMode;

public final class BootstrapHelper {
    private BootstrapHelper() {
    }

    public static File getInstallDirectory(Class<?> clazz) throws IllegalStateException {
        URL url;
        String name = clazz.getName();
        int last = name.lastIndexOf(46);
        if (last != -1) {
            name = name.substring(last + 1);
        }
        if ((url = clazz.getResource(name = name + ".class")) == null) {
            throw new IllegalStateException("Unable to get location of bytecode resource " + name);
        }
        String jarLocation = url.toString();
        if (!jarLocation.startsWith("jar:")) {
            throw new IllegalStateException("Must be run from a jar: " + url);
        }
        if (!(jarLocation = jarLocation.substring(4, jarLocation.lastIndexOf("!/"))).startsWith("file:")) {
            throw new IllegalStateException("Must be run from a local filesystem: " + jarLocation);
        }
        File jarFile = new File(URI.create(jarLocation));
        return jarFile.getParentFile().getParentFile();
    }

    public static File getDirectory(File baseDir, String path) throws Fabric3Exception {
        File dir = new File(baseDir, path);
        if (!dir.exists()) {
            throw new Fabric3Exception("Directory does not exist: " + dir);
        }
        if (!dir.isDirectory()) {
            throw new Fabric3Exception("Resource is not a directory: " + dir);
        }
        return dir;
    }

    public static ClassLoader createClassLoader(ClassLoader parent, File directory) {
        File[] jars = directory.listFiles(file -> {
            if (file.isHidden()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            try {
                JarFile jar = new JarFile(file);
                return jar.getManifest() != null;
            }
            catch (IOException e) {
                return false;
            }
        });
        if (jars == null) {
            return new DelegatingResourceClassLoader(new URL[0], parent);
        }
        URL[] urls = new URL[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            try {
                urls[i] = jars[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new AssertionError();
            }
        }
        return new DelegatingResourceClassLoader(urls, parent);
    }

    public static void cloneRuntimeImage(File sourceConfigDir, File targetDir) {
        File targetConfigDir = new File(targetDir, "config");
        FileHelper.forceMkdir(targetConfigDir);
        FileHelper.copyDirectory(sourceConfigDir, targetConfigDir);
        FileHelper.forceMkdir(new File(targetDir, "data"));
        File targetDeployDir = new File(targetDir, "deploy");
        FileHelper.forceMkdir(targetDeployDir);
        File sourceDeployDir = new File(targetConfigDir.getParent(), "deploy");
        FileHelper.copyDirectory(sourceDeployDir, targetDeployDir);
        File repository = new File(targetDir, "repository");
        FileHelper.forceMkdir(repository);
        FileHelper.forceMkdir(new File(repository, "runtime"));
        FileHelper.forceMkdir(new File(repository, "user"));
        FileHelper.forceMkdir(new File(targetDir, "tmp"));
    }

    public static HostInfo createHostInfo(String runtimeName, String zoneName, RuntimeMode runtimeMode, URI domainName, String environment, File runtimeDir, File extensionsDir, List<File> deployDirectories, boolean javaEEXAEnabled) throws IOException {
        File tempDir = BootstrapHelper.getDirectory(runtimeDir, "tmp");
        File dataDir = BootstrapHelper.getDirectory(runtimeDir, "data");
        File deployDir = new File(runtimeDir, "deploy");
        ArrayList<File> deployDirs = new ArrayList<File>();
        for (File directory : deployDirectories) {
            if (!directory.isAbsolute()) {
                directory = new File(runtimeDir, directory.getName());
            }
            if (deployDir.equals(directory) || deployDirs.contains(directory)) continue;
            deployDirs.add(directory);
        }
        deployDirs.add(deployDir);
        OperatingSystem os = BootstrapHelper.getOperatingSystem();
        DefaultHostInfoBuilder builder = new DefaultHostInfoBuilder().runtimeName(runtimeName);
        builder.zoneName(zoneName);
        builder.runtimeMode(runtimeMode);
        builder.environment(environment);
        builder.domain(domainName);
        builder.baseDir(runtimeDir);
        builder.sharedDirectory(extensionsDir);
        builder.dataDirectory(dataDir);
        builder.tempDirectory(tempDir);
        builder.deployDirectories(deployDirs);
        builder.operatingSystem(os);
        builder.javaEEXAEnabled(javaEEXAEnabled);
        return builder.build();
    }

    public static OperatingSystem getOperatingSystem() {
        String name = System.getProperty("os.name");
        String processor = OSHelper.parseProcessor(System.getProperty("os.arch"));
        String versionStr = OSHelper.parseVersion(System.getProperty("os.version"));
        Version version = Version.parseVersion(versionStr);
        return new OperatingSystem(name, processor, version);
    }
}

