/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.runtime;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.host.os.OperatingSystem;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;

public class DefaultHostInfo
implements HostInfo {
    private String runtimeName;
    private String zoneName;
    private RuntimeMode runtimeMode;
    private String environment;
    private URI domain;
    private File baseDir;
    private File sharedDirectory;
    private File tempDirectory;
    private File nativeDirectory;
    private List<File> deployDirectories;
    private OperatingSystem operatingSystem;
    private boolean javaEEXAEnabled;
    private File dataDirectory;
    private List<Runnable> callbacks = new ArrayList<Runnable>();

    public DefaultHostInfo(String runtimeName, String zoneName, RuntimeMode runtimeMode, String environment, URI domain, File baseDir, File sharedDirectory, File dataDirectory, File tempDirectory, List<File> deployDirectories, OperatingSystem operatingSystem, boolean javaEEXAEnabled) {
        this.runtimeName = runtimeName;
        this.zoneName = zoneName;
        this.runtimeMode = runtimeMode;
        this.environment = environment;
        this.domain = domain;
        this.baseDir = baseDir;
        this.sharedDirectory = sharedDirectory;
        this.dataDirectory = dataDirectory;
        this.tempDirectory = tempDirectory;
        this.javaEEXAEnabled = javaEEXAEnabled;
        this.nativeDirectory = new File(tempDirectory, "native");
        this.deployDirectories = deployDirectories;
        this.operatingSystem = operatingSystem;
    }

    @Override
    public String getRuntimeName() {
        return this.runtimeName;
    }

    @Override
    public String getZoneName() {
        return this.zoneName;
    }

    @Override
    public RuntimeMode getRuntimeMode() {
        return this.runtimeMode;
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public URI getDomain() {
        return this.domain;
    }

    @Override
    public final File getBaseDir() {
        return this.baseDir;
    }

    @Override
    public File getTempDir() {
        return this.tempDirectory;
    }

    @Override
    public File getNativeLibraryDir() {
        return this.nativeDirectory;
    }

    @Override
    public File getDataDir() {
        return this.dataDirectory;
    }

    @Override
    public boolean supportsClassLoaderIsolation() {
        return true;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public File getExtensionsRepositoryDirectory() {
        return this.sharedDirectory;
    }

    @Override
    public List<File> getDeployDirectories() {
        return this.deployDirectories;
    }

    @Override
    public boolean isJavaEEXAEnabled() {
        return this.javaEEXAEnabled;
    }

    @Override
    public void addBootCallback(Runnable callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void notifyCallbacks() {
        this.callbacks.forEach(Runnable::run);
    }
}

