/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.StringTokenizer;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.util.IOHelper;

public class FileHelper {
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    public static String PARENT_DIRECTORY_INDICATOR = "..";
    public static String CURRENT_DIRECTORY_INDICATOR = ".";

    protected FileHelper() {
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileHelper.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = FileHelper.indexOfLastSeparator(fileName);
        return fileName.substring(index + 1);
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileHelper.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static void forceMkdir(File directory) throws Fabric3Exception {
        if (directory == null) {
            return;
        }
        if (directory.exists()) {
            if (directory.isFile()) {
                String message = "File " + directory + " exists and is not a directory. Unable to create directory.";
                throw new Fabric3Exception(message);
            }
        } else if (!directory.mkdirs()) {
            String message = "Unable to create directory " + directory;
            throw new Fabric3Exception(message);
        }
    }

    public static void forceDelete(File file) throws Fabric3Exception {
        if (file.isDirectory()) {
            FileHelper.deleteDirectory(file);
        } else {
            if (!file.exists()) {
                throw new Fabric3Exception("File does not exist: " + file);
            }
            if (!file.delete()) {
                String message = "Unable to delete file: " + file;
                throw new Fabric3Exception(message);
            }
        }
    }

    public static File toFile(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        return new File(FileHelper.toFileString(url));
    }

    public static String toFileString(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return filename;
    }

    public static void cleanDirectory(File directory) throws Fabric3Exception {
        if (directory == null) {
            return;
        }
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new Fabric3Exception("Failed to list contents of " + directory);
        }
        Fabric3Exception exception = null;
        for (File file : files) {
            try {
                FileHelper.forceDelete(file);
            }
            catch (Fabric3Exception ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    private static void cleanDirectoryOnExit(File directory) throws Fabric3Exception {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new Fabric3Exception("Failed to list contents of " + directory);
        }
        Fabric3Exception exception = null;
        for (File file : files) {
            try {
                FileHelper.forceDeleteOnExit(file);
            }
            catch (Fabric3Exception ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void copyDirectory(File srcDir, File destDir) throws Fabric3Exception {
        FileHelper.copyDirectory(srcDir, destDir, true);
    }

    public static void copyDirectory(File srcDir, File destDir, boolean preserveFileDate) throws Fabric3Exception {
        try {
            if (srcDir == null) {
                throw new NullPointerException("Source must not be null");
            }
            if (destDir == null) {
                throw new NullPointerException("Destination must not be null");
            }
            if (!srcDir.exists()) {
                throw new Fabric3Exception("Source '" + srcDir + "' does not exist");
            }
            if (!srcDir.isDirectory()) {
                throw new Fabric3Exception("Source '" + srcDir + "' exists but is not a directory");
            }
            if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
                throw new Fabric3Exception("Source '" + srcDir + "' and destination '" + destDir + "' are the same");
            }
            FileHelper.doCopyDirectory(srcDir, destDir, preserveFileDate);
        }
        catch (IOException e) {
            throw new Fabric3Exception(e);
        }
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir) throws Fabric3Exception {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            throw new IllegalArgumentException("Source '" + destDir + "' is not a directory");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!destDir.exists() || !destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + destDir + "' is not a directory");
        }
        FileHelper.copyDirectory(srcDir, new File(destDir, srcDir.getName()), true);
    }

    public static void copyFile(File srcFile, File destFile) throws Fabric3Exception {
        FileHelper.copyFile(srcFile, destFile, true);
    }

    public static void copyFile(File srcFile, File destFile, boolean preserveFileDate) throws Fabric3Exception {
        try {
            if (srcFile == null) {
                throw new NullPointerException("Source must not be null");
            }
            if (destFile == null) {
                throw new NullPointerException("Destination must not be null");
            }
            if (!srcFile.exists()) {
                throw new Fabric3Exception("Source '" + srcFile + "' does not exist");
            }
            if (srcFile.isDirectory()) {
                throw new Fabric3Exception("Source '" + srcFile + "' exists but is a directory");
            }
            if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {
                throw new Fabric3Exception("Source '" + srcFile + "' and destination '" + destFile + "' are the same");
            }
            if (destFile.getParentFile() != null && !destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
                throw new Fabric3Exception("Destination '" + destFile + "' directory cannot be created");
            }
            if (destFile.exists() && !destFile.canWrite()) {
                throw new Fabric3Exception("Destination '" + destFile + "' exists but is read-only");
            }
            FileHelper.doCopyFile(srcFile, destFile, preserveFileDate);
        }
        catch (IOException e) {
            throw new Fabric3Exception(e);
        }
    }

    public static void copyFileToDirectory(File srcFile, File destDir) throws Fabric3Exception {
        FileHelper.copyFileToDirectory(srcFile, destDir, true);
    }

    public static void copyFileToDirectory(File srcFile, File destDir, boolean preserveFileDate) throws Fabric3Exception {
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!destDir.exists() || !destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + destDir + "' is not a directory");
        }
        FileHelper.copyFile(srcFile, new File(destDir, srcFile.getName()), preserveFileDate);
    }

    public static void deleteDirectory(File directory) throws Fabric3Exception {
        if (!directory.exists()) {
            return;
        }
        FileHelper.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new Fabric3Exception(message);
        }
    }

    public static void write(InputStream source, File target) throws Fabric3Exception {
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        try (RandomAccessFile file = new RandomAccessFile(target, "rw");){
            int limit;
            channel = file.getChannel();
            lock = ((FileChannel)channel).lock();
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            byte[] bytes = buffer.array();
            while (-1 != (limit = source.read(bytes))) {
                buffer.flip();
                buffer.limit(limit);
                while (buffer.hasRemaining()) {
                    ((FileChannel)channel).write(buffer);
                }
                buffer.clear();
            }
            ((FileChannel)channel).force(true);
        }
        catch (IOException e) {
            throw new Fabric3Exception(e);
        }
        finally {
            if (channel != null) {
                if (lock != null) {
                    try {
                        lock.release();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void deleteDirectoryOnExit(File directory) throws Fabric3Exception {
        if (!directory.exists()) {
            return;
        }
        FileHelper.cleanDirectoryOnExit(directory);
        directory.deleteOnExit();
    }

    private static void doCopyDirectory(File srcDir, File destDir, boolean preserveFileDate) throws Fabric3Exception {
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new Fabric3Exception("Destination '" + destDir + "' exists but is not a directory");
            }
        } else {
            if (!destDir.mkdirs()) {
                throw new Fabric3Exception("Destination '" + destDir + "' directory cannot be created");
            }
            if (preserveFileDate) {
                destDir.setLastModified(srcDir.lastModified());
            }
        }
        if (!destDir.canWrite()) {
            throw new Fabric3Exception("Destination '" + destDir + "' cannot be written to");
        }
        File[] files = srcDir.listFiles();
        if (files == null) {
            throw new Fabric3Exception("Failed to list contents of " + srcDir);
        }
        for (File file : files) {
            File copiedFile = new File(destDir, file.getName());
            if (file.isDirectory()) {
                FileHelper.doCopyDirectory(file, copiedFile, preserveFileDate);
                continue;
            }
            FileHelper.doCopyFile(file, copiedFile, preserveFileDate);
        }
    }

    private static void doCopyFile(File srcFile, File destFile, boolean preserveFileDate) throws Fabric3Exception {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new Fabric3Exception("Destination '" + destFile + "' exists but is a directory");
        }
        FileOutputStream output = null;
        try (FileInputStream input = new FileInputStream(srcFile);){
            output = new FileOutputStream(destFile);
            IOHelper.copy(input, output);
        }
        catch (IOException e) {
            throw new Fabric3Exception(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (srcFile.length() != destFile.length()) {
            throw new Fabric3Exception("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
        if (preserveFileDate) {
            destFile.setLastModified(srcFile.lastModified());
        }
    }

    public static void forceDeleteOnExit(File file) throws Fabric3Exception {
        if (file.isDirectory()) {
            FileHelper.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    public static String resolveRelativePath(String parentLocation, String childLocation) {
        String path = childLocation;
        String fwdSlash = "/";
        if (path == null || "".equals(path) || parentLocation == null || "".equals(parentLocation)) {
            return path;
        }
        if (!FileHelper.isAbsolute(path)) {
            String basePath = parentLocation;
            basePath = basePath.replace('\\', '/');
            basePath = basePath.substring(0, basePath.lastIndexOf(47) + 1);
            if (path.startsWith(CURRENT_DIRECTORY_INDICATOR + fwdSlash)) {
                path = path.substring(2);
            } else if (path.startsWith(PARENT_DIRECTORY_INDICATOR)) {
                StringBuilder builder = new StringBuilder();
                StringTokenizer tokenizer = new StringTokenizer(path, fwdSlash);
                int countParentInd = 0;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (PARENT_DIRECTORY_INDICATOR.equals(token)) {
                        ++countParentInd;
                        continue;
                    }
                    builder.append(fwdSlash).append(token);
                }
                if (basePath.endsWith(fwdSlash)) {
                    basePath = basePath.substring(0, basePath.length() - 1);
                }
                for (int i = 0; i < countParentInd; ++i) {
                    int lastIdx = basePath.lastIndexOf(fwdSlash);
                    basePath = basePath.substring(0, lastIdx);
                    if (i == countParentInd - 1 || (!basePath.endsWith(fwdSlash) || basePath.length() != 1) && !basePath.endsWith(":")) continue;
                    int addParentIndCount = countParentInd - 1 - i;
                    for (int j = 0; j < addParentIndCount; ++j) {
                        basePath = basePath.endsWith(":") || basePath.endsWith(PARENT_DIRECTORY_INDICATOR) ? basePath + fwdSlash + PARENT_DIRECTORY_INDICATOR : basePath + PARENT_DIRECTORY_INDICATOR;
                    }
                    break;
                }
                path = builder.toString();
            }
            path = basePath + path;
        }
        return path;
    }

    public static boolean isAbsolute(String aPath) {
        boolean absolute = false;
        String path = aPath.replace('\\', '/');
        if (path.indexOf(58) > 0 && path.indexOf(47) > path.indexOf(58)) {
            absolute = true;
        } else if (path.startsWith("/")) {
            absolute = true;
        }
        return absolute;
    }
}

