/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.host.util;

import java.util.StringTokenizer;

public final class OSHelper {
    private static final String VERSION_DELIMETER = ".";
    private static final String QUALIFIER_DELIMETER = "-";

    public static String parseProcessor(String value) {
        if ((value = value.toLowerCase()).startsWith("x86_64") || value.startsWith("amd64")) {
            return "x86_64";
        }
        if (value.startsWith("x86") || value.startsWith("pentium") || value.startsWith("i386") || value.startsWith("i486") || value.startsWith("i586") || value.startsWith("i686")) {
            return "x86";
        }
        if (value.startsWith("68k")) {
            return "68k";
        }
        if (value.startsWith("arm")) {
            return "arm";
        }
        if (value.startsWith("alpha")) {
            return "alpha";
        }
        if (value.startsWith("ignite") || value.startsWith("psc1k")) {
            return "ignite";
        }
        if (value.startsWith("mips")) {
            return "mips";
        }
        if (value.startsWith("parisc")) {
            return "parisc";
        }
        if (value.startsWith("powerpc") || value.startsWith("power") || value.startsWith("ppc")) {
            return "powerpc";
        }
        if (value.startsWith("sparc")) {
            return "sparc";
        }
        return value;
    }

    public static String parseVersion(String value) {
        int major;
        int minor = 0;
        int micro = 0;
        try {
            StringTokenizer st = new StringTokenizer(value, VERSION_DELIMETER, true);
            major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    String microStr = st.nextToken();
                    micro = !microStr.contains(QUALIFIER_DELIMETER) ? Integer.parseInt(microStr) : Integer.parseInt(microStr.substring(0, microStr.indexOf(QUALIFIER_DELIMETER)));
                }
            }
        }
        catch (Exception ex) {
            return "0.0.0";
        }
        return major + VERSION_DELIMETER + minor + VERSION_DELIMETER + micro;
    }
}

