/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class F3NamespaceContext
implements NamespaceContext {
    private Map<String, String> prefixesToUris = new HashMap<String, String>();
    private Map<String, List<String>> urisToPrefixes = new HashMap<String, List<String>>();

    public F3NamespaceContext() {
        this.prefixesToUris.put("sca", "http://docs.oasis-open.org/ns/opencsa/sca/200912");
        this.prefixesToUris.put("f3", "urn:fabric3.org");
        ArrayList<String> sca = new ArrayList<String>();
        sca.add("sca");
        this.urisToPrefixes.put("http://docs.oasis-open.org/ns/opencsa/sca/200912", sca);
        ArrayList<String> f3 = new ArrayList<String>();
        f3.add("f3");
        this.urisToPrefixes.put("urn:fabric3.org", f3);
    }

    public void add(String prefix, String namespace) {
        this.prefixesToUris.put(prefix, namespace);
        List<String> prefixes = this.urisToPrefixes.get(namespace);
        if (prefixes == null) {
            prefixes = new ArrayList<String>();
            this.urisToPrefixes.put(namespace, prefixes);
        }
        prefixes.add(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.prefixesToUris.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        List<String> list = this.urisToPrefixes.get(namespaceURI);
        return list == null ? null : list.get(0);
    }

    public Iterator getPrefixes(String namespaceURI) {
        List<String> list = this.urisToPrefixes.get(namespaceURI);
        return list == null ? null : list.iterator();
    }
}

