/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.builder;

import org.fabric3.api.model.type.F3NamespaceContext;
import org.fabric3.api.model.type.builder.AbstractBuilder;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.component.PropertyValue;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.Service;
import org.fabric3.api.model.type.component.Target;

public abstract class ComponentBuilder<T extends ComponentBuilder>
extends AbstractBuilder {
    public T binding(String serviceName, Binding bindingDefinition) {
        this.checkState();
        Component<?> definition = this.getComponent();
        Service<Component<Object>> service = definition.getServices().get(serviceName);
        if (service == null) {
            service = new Service(serviceName);
            definition.add(service);
        }
        service.addBinding(bindingDefinition);
        return this.builder();
    }

    public T reference(String name, String target) {
        this.checkState();
        Component<?> definition = this.getComponent();
        Reference<Component> reference = new Reference<Component>(name, Multiplicity.ONE_ONE);
        reference.addTarget(new Target(target));
        definition.add(reference);
        return this.builder();
    }

    public T reference(String name, String target, boolean required) {
        this.checkState();
        Component<?> definition = this.getComponent();
        Multiplicity multiplicity = required ? Multiplicity.ONE_ONE : Multiplicity.ZERO_ONE;
        Reference<Component> reference = new Reference<Component>(name, multiplicity);
        reference.addTarget(new Target(target));
        definition.add(reference);
        return this.builder();
    }

    public T reference(String name, String target, Multiplicity multiplicity) {
        this.checkState();
        Component<?> definition = this.getComponent();
        Reference<Component> reference = new Reference<Component>(name, multiplicity);
        reference.addTarget(new Target(target));
        definition.add(reference);
        return this.builder();
    }

    public T property(String name, Object value) {
        this.checkState();
        PropertyValue propertyValue = new PropertyValue(name, value);
        this.getComponent().add(propertyValue);
        return this.builder();
    }

    public T propertyExpression(String name, String xpath) {
        this.checkState();
        PropertyValue propertyValue = new PropertyValue(name, xpath);
        propertyValue.setNamespaceContext(new F3NamespaceContext());
        this.getComponent().add(propertyValue);
        return this.builder();
    }

    public T key(Object key) {
        this.checkState();
        this.getComponent().setKey(key.toString());
        return this.builder();
    }

    public T order(int order) {
        this.checkState();
        this.getComponent().setOrder(order);
        return this.builder();
    }

    protected abstract Component<?> getComponent();

    private T builder() {
        return (T)this;
    }
}

