/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.builder;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.api.model.type.builder.AbstractBuilder;
import org.fabric3.api.model.type.builder.ModelBuilderException;
import org.fabric3.api.model.type.component.Channel;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Include;
import org.fabric3.api.model.type.component.Property;
import org.fabric3.api.model.type.component.Resource;
import org.fabric3.api.model.type.component.Wire;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CompositeBuilder
extends AbstractBuilder {
    private static final DocumentBuilderFactory DOCUMENT_FACTORY = DocumentBuilderFactory.newInstance();
    private Composite composite;

    public static CompositeBuilder newBuilder(QName name) {
        return new CompositeBuilder(name);
    }

    public CompositeBuilder component(Component<?> definition) {
        this.checkState();
        this.composite.add(definition);
        return this;
    }

    public CompositeBuilder channel(Channel definition) {
        this.checkState();
        this.composite.add(definition);
        return this;
    }

    public CompositeBuilder resource(Resource definition) {
        this.checkState();
        this.composite.add(definition);
        return this;
    }

    public CompositeBuilder include(Composite included) {
        this.checkState();
        Include include = new Include();
        include.setIncluded(included);
        include.setName(included.getName());
        this.composite.add(include);
        return this;
    }

    public CompositeBuilder wire(Wire wire) {
        this.checkState();
        this.composite.add(wire);
        return this;
    }

    public CompositeBuilder deployable() {
        this.checkState();
        this.composite.setDeployable(true);
        return this;
    }

    public CompositeBuilder mode(List<RuntimeMode> modes) {
        this.checkState();
        this.composite.setModes(modes);
        return this;
    }

    public CompositeBuilder environment(List<String> environments) {
        this.checkState();
        this.composite.setEnvironments(environments);
        return this;
    }

    public Composite build() {
        this.checkState();
        this.freeze();
        return this.composite;
    }

    public CompositeBuilder property(String name, URL source) {
        this.checkState();
        try {
            Document document = DOCUMENT_FACTORY.newDocumentBuilder().parse(source.openStream());
            Element oldRoot = document.getDocumentElement();
            Element newRoot = document.createElement("values");
            document.removeChild(oldRoot);
            document.appendChild(newRoot);
            newRoot.appendChild(oldRoot);
            Property property = new Property(name);
            property.setDefaultValue(document);
            this.composite.add(property);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ModelBuilderException(e);
        }
        return this;
    }

    protected CompositeBuilder(QName name) {
        this.composite = new Composite(name);
    }

    static {
        DOCUMENT_FACTORY.setNamespaceAware(true);
    }
}

