/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.builder;

import java.util.ArrayList;
import org.fabric3.api.model.type.builder.AbstractBuilder;
import org.fabric3.api.model.type.resource.datasource.DataSourceConfiguration;
import org.fabric3.api.model.type.resource.datasource.DataSourceType;

public class DataSourceConfigurationBuilder
extends AbstractBuilder {
    private DataSourceConfiguration configuration;

    public static DataSourceConfigurationBuilder newBuilder(String name, String driverClass, DataSourceType type) {
        return new DataSourceConfigurationBuilder(name, driverClass, type);
    }

    private DataSourceConfigurationBuilder(String name, String driverClass, DataSourceType type) {
        this.configuration = new DataSourceConfiguration(name, driverClass, type);
        this.configuration.setAliases(new ArrayList<String>());
    }

    public DataSourceConfigurationBuilder alias(String alias) {
        this.checkState();
        this.configuration.getAliases().add(alias);
        return this;
    }

    public DataSourceConfigurationBuilder connectionTimeout(int timeout) {
        this.checkState();
        this.configuration.setConnectionTimeout(timeout);
        return this;
    }

    public DataSourceConfigurationBuilder loginTimeout(int timeout) {
        this.checkState();
        this.configuration.setLoginTimeout(timeout);
        return this;
    }

    public DataSourceConfigurationBuilder maintenanceInterval(int interval) {
        this.checkState();
        this.configuration.setMaintenanceInterval(interval);
        return this;
    }

    public DataSourceConfigurationBuilder maxIdle(int idle) {
        this.checkState();
        this.configuration.setMaxIdle(idle);
        return this;
    }

    public DataSourceConfigurationBuilder maxPoolSize(int size) {
        this.checkState();
        this.configuration.setMaxPoolSize(size);
        return this;
    }

    public DataSourceConfigurationBuilder minPoolSize(int size) {
        this.checkState();
        this.configuration.setMinPoolSize(size);
        return this;
    }

    public DataSourceConfigurationBuilder poolSize(int size) {
        this.checkState();
        this.configuration.setPoolSize(size);
        return this;
    }

    public DataSourceConfigurationBuilder password(String password) {
        this.checkState();
        this.configuration.setPassword(password);
        return this;
    }

    public DataSourceConfigurationBuilder username(String name) {
        this.checkState();
        this.configuration.setUsername(name);
        return this;
    }

    public DataSourceConfigurationBuilder property(String name, String value) {
        this.checkState();
        this.configuration.setProperty(name, value);
        return this;
    }

    public DataSourceConfigurationBuilder query(String query) {
        this.checkState();
        this.configuration.setQuery(query);
        return this;
    }

    public DataSourceConfigurationBuilder reap(int reap) {
        this.checkState();
        this.configuration.setReap(reap);
        return this;
    }

    public DataSourceConfigurationBuilder url(String url) {
        this.checkState();
        this.configuration.setUrl(url);
        return this;
    }

    public DataSourceConfiguration build() {
        this.checkState();
        this.freeze();
        return this.configuration;
    }
}

