/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.builder;

import javax.xml.namespace.QName;
import org.fabric3.api.model.type.builder.AbstractBuilder;
import org.fabric3.api.model.type.component.Channel;
import org.fabric3.api.model.type.component.RingBufferData;

public class RingBufferChannelBuilder
extends AbstractBuilder {
    private static final QName METADATA = new QName("urn:fabric3.org", "metadata");
    private final Channel definition;
    private final RingBufferData data;

    public static RingBufferChannelBuilder newBuilder(String name) {
        return new RingBufferChannelBuilder(name);
    }

    protected RingBufferChannelBuilder(String name) {
        this.definition = new Channel(name);
        this.data = new RingBufferData();
        this.definition.setMetadata(this.data);
    }

    public RingBufferChannelBuilder type(String type) {
        this.checkState();
        this.definition.setType(type);
        return this;
    }

    public RingBufferChannelBuilder ringSize(int size) {
        this.checkState();
        this.data.setRingSize(size);
        return this;
    }

    public RingBufferChannelBuilder blockingTimeout(long nanos) {
        this.checkState();
        this.data.setBlockingTimeoutNanos(nanos);
        return this;
    }

    public RingBufferChannelBuilder phasedBlockingType(RingBufferData.PhasedBlockingType type) {
        this.checkState();
        this.data.setPhasedBlockingType(type);
        return this;
    }

    public RingBufferChannelBuilder spinTimeout(long nanos) {
        this.checkState();
        this.data.setSpinTimeoutNanos(nanos);
        return this;
    }

    public RingBufferChannelBuilder waitStrategy(RingBufferData.WaitStrategyType strategy) {
        this.checkState();
        this.data.setWaitStrategy(strategy);
        return this;
    }

    public RingBufferChannelBuilder yieldTimeout(long nanos) {
        this.checkState();
        this.data.setYieldTimeoutNanos(nanos);
        return this;
    }

    public Channel build() {
        this.checkState();
        this.freeze();
        return this.definition;
    }
}

