/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.builder;

import org.fabric3.api.model.type.builder.AbstractBuilder;
import org.fabric3.api.model.type.component.Target;
import org.fabric3.api.model.type.component.Wire;

public class WireBuilder
extends AbstractBuilder {
    private Target reference;
    private Target service;

    public static WireBuilder newBuilder() {
        return new WireBuilder();
    }

    public WireBuilder source(String value) {
        this.checkState();
        this.reference = this.parseTarget(value);
        return this;
    }

    public WireBuilder target(String value) {
        this.checkState();
        this.service = this.parseTarget(value);
        return this;
    }

    public Wire build() {
        this.checkState();
        this.freeze();
        return new Wire(this.reference, this.service);
    }

    protected WireBuilder() {
    }

    private Target parseTarget(String target) {
        String[] tokens = target.split("/");
        if (tokens.length == 1) {
            return new Target(tokens[0]);
        }
        if (tokens.length == 2) {
            return new Target(tokens[0], tokens[1]);
        }
        if (tokens.length == 3) {
            return new Target(tokens[0], tokens[1], tokens[2]);
        }
        throw new IllegalArgumentException("Invalid target format: " + target);
    }
}

