/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.component;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Bindable;
import org.fabric3.api.model.type.component.BindingHandler;

public abstract class Binding
extends ModelObject<Bindable> {
    protected URI targetUri;
    protected String type;
    protected String name;
    private List<BindingHandler> handlers = new ArrayList<BindingHandler>();
    private Set<Class<?>> connectionTypes = Collections.emptySet();

    public Binding(URI targetUri, String type) {
        this.targetUri = targetUri;
        this.type = type;
    }

    public Binding(String name, URI targetUri, String type) {
        this.name = name;
        this.targetUri = targetUri;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URI getTargetUri() {
        return this.targetUri;
    }

    public String getType() {
        return this.type;
    }

    public List<BindingHandler> getHandlers() {
        return this.handlers;
    }

    public void addHandler(BindingHandler handler) {
        this.handlers.add(handler);
    }

    public Set<Class<?>> getConnectionTypes() {
        return this.connectionTypes;
    }

    public void setConnectionTypes(Class<?> ... types) {
        this.connectionTypes = new HashSet(Arrays.asList(types));
    }
}

