/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.component;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Consumer;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Producer;
import org.fabric3.api.model.type.component.PropertyValue;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.Service;

public class Component<I extends Implementation<?>>
extends ModelObject<Composite> {
    private String name;
    private I implementation;
    private String key;
    private int order = Integer.MIN_VALUE;
    private URI contributionUri;
    private Map<String, Service<Component>> services = new HashMap<String, Service<Component>>();
    private Map<String, Reference<Component>> references = new HashMap<String, Reference<Component>>();
    private Map<String, Producer<Component>> producers = new HashMap<String, Producer<Component>>();
    private Map<String, Consumer<Component>> consumers = new HashMap<String, Consumer<Component>>();
    private Map<String, PropertyValue> propertyValues = new HashMap<String, PropertyValue>();

    public Component(String name) {
        this.name = name;
    }

    public Component(String name, I implementation) {
        this.name = name;
        this.implementation = implementation;
    }

    public void setImplementation(I implementation) {
        ((ModelObject)implementation).setParent((Component)this);
        this.implementation = implementation;
    }

    public I getImplementation() {
        return this.implementation;
    }

    public ComponentType getComponentType() {
        return this.implementation != null ? (ComponentType)((Implementation)this.getImplementation()).getComponentType() : null;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Reference<Component>> getReferences() {
        return this.references;
    }

    public void add(Reference<Component> reference) {
        reference.setParent(this);
        this.references.put(reference.getName(), reference);
    }

    public Map<String, Service<Component>> getServices() {
        return this.services;
    }

    public void add(Service<Component> service) {
        service.setParent(this);
        this.services.put(service.getName(), service);
    }

    public void add(Producer<Component> producer) {
        producer.setParent(this);
        this.producers.put(producer.getName(), producer);
    }

    public Map<String, Producer<Component>> getProducers() {
        return this.producers;
    }

    public void add(Consumer<Component> consumer) {
        consumer.setParent(this);
        this.consumers.put(consumer.getName(), consumer);
    }

    public Map<String, Consumer<Component>> getConsumers() {
        return this.consumers;
    }

    public Map<String, PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    public void add(PropertyValue value) {
        value.setParent(this);
        this.propertyValues.put(value.getName(), value);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public URI getContributionUri() {
        return this.contributionUri;
    }

    public void setContributionUri(URI contributionUri) {
        this.contributionUri = contributionUri;
    }
}

