/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.Consumer;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Producer;
import org.fabric3.api.model.type.component.Property;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.ResourceReference;
import org.fabric3.api.model.type.component.Service;

public class ComponentType
extends ModelObject<Implementation>
implements PolicyAware {
    private String key;
    private int order = Integer.MIN_VALUE;
    private Map<String, Service<ComponentType>> services = new HashMap<String, Service<ComponentType>>();
    private Map<String, Consumer<ComponentType>> consumers = new HashMap<String, Consumer<ComponentType>>();
    private Map<String, Reference<ComponentType>> references = new HashMap<String, Reference<ComponentType>>();
    private Map<String, Producer<ComponentType>> producers = new HashMap<String, Producer<ComponentType>>();
    private Map<String, Property> properties = new HashMap<String, Property>();
    private Map<String, ResourceReference> resourceReferences = new HashMap<String, ResourceReference>();
    private List<String> policies;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Map<String, Service<ComponentType>> getServices() {
        return this.services;
    }

    public void add(Service<ComponentType> service) {
        service.setParent(this);
        this.services.put(service.getName(), service);
    }

    public Map<String, Consumer<ComponentType>> getConsumers() {
        return this.consumers;
    }

    public void add(Consumer<ComponentType> consumer) {
        consumer.setParent(this);
        this.consumers.put(consumer.getName(), consumer);
    }

    public Map<String, Reference<ComponentType>> getReferences() {
        return this.references;
    }

    public void add(Reference<ComponentType> reference) {
        reference.setParent(this);
        this.references.put(reference.getName(), reference);
    }

    public Map<String, Producer<ComponentType>> getProducers() {
        return this.producers;
    }

    public void add(Producer<ComponentType> producer) {
        producer.setParent(this);
        this.producers.put(producer.getName(), producer);
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public void add(Property property) {
        property.setParent(this);
        this.properties.put(property.getName(), property);
    }

    public Map<String, ResourceReference> getResourceReferences() {
        return this.resourceReferences;
    }

    public void add(ResourceReference definition) {
        definition.setParent(this);
        this.resourceReferences.put(definition.getName(), definition);
    }

    @Override
    public void addPolicy(String policy) {
        if (this.policies == null) {
            this.policies = new ArrayList<String>();
        }
        this.policies.add(policy);
    }

    @Override
    public List<String> getPolicies() {
        return this.policies == null ? Collections.emptyList() : this.policies;
    }
}

