/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.component;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.Namespace;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.api.model.type.component.Channel;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Include;
import org.fabric3.api.model.type.component.Resource;
import org.fabric3.api.model.type.component.Wire;

public class Composite
extends ComponentType {
    private QName name;
    private URI contributionUri;
    private boolean deployable;
    private List<RuntimeMode> modes = Arrays.asList(RuntimeMode.VM, RuntimeMode.NODE);
    private List<String> environments = Collections.emptyList();
    private Map<String, Component<? extends Implementation<?>>> components = new HashMap();
    private Map<QName, Include> includes = new HashMap<QName, Include>();
    private List<Wire> wires = new ArrayList<Wire>();
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    private List<Resource> resources = new ArrayList<Resource>();
    private Map<String, Component<? extends Implementation<?>>> componentsView = new HashMap();
    private Map<String, Channel> channelsView = new HashMap<String, Channel>();
    private List<Wire> wiresView = new ArrayList<Wire>();
    private List<Resource> resourcesView = new ArrayList<Resource>();
    private List<Namespace> namespaces;

    public Composite(QName name) {
        this.name = name;
    }

    public Composite(QName name, URI uri) {
        this.name = name;
        this.contributionUri = uri;
    }

    public QName getName() {
        return this.name;
    }

    public URI getContributionUri() {
        return this.contributionUri;
    }

    public void setContributionUri(URI contributionUri) {
        this.contributionUri = contributionUri;
    }

    public boolean isDeployable() {
        return this.deployable;
    }

    public void setDeployable(boolean deployable) {
        this.deployable = deployable;
    }

    public List<RuntimeMode> getModes() {
        return this.modes;
    }

    public void setModes(List<RuntimeMode> modes) {
        this.modes = modes;
    }

    public List<String> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<String> environments) {
        this.environments = environments;
    }

    public Map<String, Component<? extends Implementation<?>>> getComponents() {
        return this.componentsView;
    }

    public void add(Component<? extends Implementation<?>> component) {
        component.setParent(this);
        this.componentsView.put(component.getName(), component);
        this.components.put(component.getName(), component);
    }

    public List<Wire> getWires() {
        return this.wiresView;
    }

    public void add(Wire wire) {
        wire.setParent(this);
        this.wires.add(wire);
        this.wiresView.add(wire);
    }

    public Map<String, Channel> getChannels() {
        return this.channelsView;
    }

    public void add(Channel channel) {
        channel.setParent(this);
        this.channelsView.put(channel.getName(), channel);
        this.channels.put(channel.getName(), channel);
    }

    public List<Resource> getResources() {
        return this.resourcesView;
    }

    public void add(Resource resource) {
        resource.setParent(this);
        this.resourcesView.add(resource);
        this.resources.add(resource);
    }

    public Map<QName, Include> getIncludes() {
        return this.includes;
    }

    public void add(Include include) {
        include.setParent(this);
        this.includes.put(include.getName(), include);
        this.componentsView.putAll(include.getIncluded().getComponents());
        this.wiresView.addAll(include.getIncluded().getWires());
        this.channelsView.putAll(include.getIncluded().getChannels());
        this.resourcesView.addAll(include.getIncluded().getResources());
    }

    public Map<String, Component<? extends Implementation<?>>> getDeclaredComponents() {
        return this.components;
    }

    public List<Wire> getDeclaredWires() {
        return this.wires;
    }

    public Map<String, Channel> getDeclaredChannels() {
        return this.channels;
    }

    public List<Resource> getDeclaredResources() {
        return this.resources;
    }

    public void addNamespace(String prefix, String uri) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<Namespace>();
        }
        this.namespaces.add(new Namespace(prefix, uri));
    }

    public List<Namespace> getNamespaces() {
        if (this.namespaces == null) {
            return Collections.emptyList();
        }
        return this.namespaces;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Composite that = (Composite)o;
        return this.name.equals(that.name);
    }
}

