/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.component;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Bindable;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.component.Target;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.ServiceContract;

public class Reference<P extends ModelObject>
extends Bindable<P> {
    private String name;
    private ServiceContract serviceContract;
    private Multiplicity multiplicity;
    private boolean keyed;
    private DataType keyDataType;
    private List<Binding> callbackBindings = new ArrayList<Binding>();
    private List<Target> targets = new ArrayList<Target>();

    public Reference(String name, ServiceContract serviceContract) {
        this(name, serviceContract, Multiplicity.ONE_ONE);
    }

    public Reference(String name, Multiplicity multiplicity) {
        this(name, null, multiplicity);
    }

    public Reference(String name) {
        this(name, null, Multiplicity.ONE_ONE);
    }

    public Reference(String name, ServiceContract serviceContract, Multiplicity multiplicity) {
        this.name = name;
        this.serviceContract = serviceContract;
        if (serviceContract != null) {
            serviceContract.setParent(this);
        }
        this.multiplicity = multiplicity;
    }

    public String getName() {
        return this.name;
    }

    public ServiceContract getServiceContract() {
        return this.serviceContract;
    }

    public void setServiceContract(ServiceContract serviceContract) {
        this.serviceContract = serviceContract;
    }

    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(Multiplicity multiplicity) {
        this.multiplicity = multiplicity;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public void addTargets(List<Target> targets) {
        this.targets.addAll(targets);
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    public boolean isRequired() {
        return this.multiplicity == Multiplicity.ONE_ONE || this.multiplicity == Multiplicity.ONE_N;
    }

    public List<Binding> getCallbackBindings() {
        return this.callbackBindings;
    }

    public void addCallbackBinding(Binding binding) {
        this.callbackBindings.add(binding);
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public void setKeyed(boolean keyed) {
        this.keyed = keyed;
    }

    public DataType getKeyDataType() {
        return this.keyDataType;
    }

    public void setKeyDataType(DataType keyDataType) {
        this.keyDataType = keyDataType;
    }
}

