/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.component;

import java.io.Serializable;

public class Scope
implements Serializable {
    private static final long serialVersionUID = -5300929173662672089L;
    public static final Scope STATELESS = new Scope("STATELESS", false);
    public static final Scope COMPOSITE = new Scope("COMPOSITE", true);
    public static final Scope DOMAIN = new Scope("DOMAIN", true);
    private final String scope;
    private final boolean singleton;

    public Scope(String scope, boolean singleton) {
        this.singleton = singleton;
        this.scope = scope.toUpperCase().intern();
    }

    public static Scope getScope(String name) {
        if (STATELESS.getScope().equals(name)) {
            return STATELESS;
        }
        if (COMPOSITE.getScope().equals(name)) {
            return COMPOSITE;
        }
        if (DOMAIN.getScope().equals(name)) {
            return DOMAIN;
        }
        throw new IllegalArgumentException("Unknown scope: " + name);
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scope scope1 = (Scope)o;
        return this.scope == scope1.scope;
    }

    public int hashCode() {
        return this.scope.hashCode();
    }

    public String toString() {
        return this.scope;
    }
}

