/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.contract;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.ServiceContract;

public class Operation
extends ModelObject<ServiceContract>
implements PolicyAware {
    private String name;
    private boolean remotable;
    private boolean oneWay;
    private DataType outputType;
    private List<DataType> inputTypes;
    private List<DataType> faultTypes;
    private List<String> policies;
    private Map<QName, Serializable> metadata = new HashMap<QName, Serializable>();

    public Operation(String name, List<DataType> inputTypes, DataType outputType, List<DataType> faultTypes) {
        this.name = name;
        List types = Collections.emptyList();
        this.inputTypes = inputTypes;
        this.outputType = outputType;
        this.faultTypes = faultTypes == null ? types : faultTypes;
    }

    public String getName() {
        return this.name;
    }

    public List<DataType> getInputTypes() {
        return this.inputTypes;
    }

    public DataType getOutputType() {
        return this.outputType;
    }

    public List<DataType> getFaultTypes() {
        if (this.faultTypes == null) {
            return Collections.emptyList();
        }
        return this.faultTypes;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }

    @Override
    public void addPolicy(String policy) {
        if (this.policies == null) {
            this.policies = new ArrayList<String>();
        }
        this.policies.add(policy);
    }

    @Override
    public List<String> getPolicies() {
        return this.policies == null ? Collections.emptyList() : this.policies;
    }

    public boolean isRemotable() {
        return this.remotable;
    }

    public void setRemotable(boolean remotable) {
        this.remotable = remotable;
    }

    public void addMetadata(QName name, Serializable data) {
        this.metadata.put(name, data);
    }

    public <T> T getMetadata(QName name, Class<T> type) {
        return type.cast(this.metadata.get(name));
    }

    public Map<QName, Serializable> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Operation [" + this.name + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operation operation = (Operation)o;
        if (this.name != null ? !this.name.equals(operation.name) : operation.name != null) {
            return false;
        }
        if (this.faultTypes == null && operation.faultTypes != null) {
            return false;
        }
        if (this.faultTypes != null && operation.faultTypes != null && this.faultTypes.size() != 0 && operation.faultTypes.size() != 0) {
            if (this.faultTypes.size() < operation.faultTypes.size()) {
                return false;
            }
            for (int i = 0; i < operation.faultTypes.size(); ++i) {
                if (this.faultTypes.get(i).equals(operation.faultTypes.get(i))) continue;
                return false;
            }
        }
        if (this.inputTypes != null ? !this.inputTypes.equals(operation.inputTypes) : operation.inputTypes != null) {
            return false;
        }
        return !(this.outputType == null ? operation.outputType != null : !this.outputType.equals(operation.outputType));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.outputType != null ? this.outputType.hashCode() : 0);
        result = 29 * result + (this.inputTypes != null ? this.inputTypes.hashCode() : 0);
        result = 29 * result + (this.faultTypes != null ? this.faultTypes.hashCode() : 0);
        return result;
    }
}

