/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.contract;

import java.util.Collections;
import java.util.List;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.contract.Operation;

public abstract class ServiceContract
extends ModelObject<ModelObject> {
    protected boolean remotable;
    protected String interfaceName;
    protected List<Operation> operations;
    protected ServiceContract callbackContract;

    protected ServiceContract() {
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public boolean isRemotable() {
        return this.remotable;
    }

    public void setRemotable(boolean remotable) {
        this.remotable = remotable;
    }

    public List<Operation> getOperations() {
        if (this.operations == null) {
            return Collections.emptyList();
        }
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        for (Operation operation : operations) {
            operation.setParent(this);
        }
        this.operations = operations;
    }

    public ServiceContract getCallbackContract() {
        return this.callbackContract;
    }

    public void setCallbackContract(ServiceContract callbackContract) {
        this.callbackContract = callbackContract;
        if (callbackContract != null) {
            callbackContract.setParent(this);
        }
    }

    public abstract String getQualifiedInterfaceName();

    public Class<?> getInterfaceClass() {
        return null;
    }

    public String toString() {
        if (this.interfaceName != null) {
            return "ServiceContract[" + this.interfaceName + "]";
        }
        return super.toString();
    }
}

