/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.model.type.java;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Callback;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Consumer;
import org.fabric3.api.model.type.component.Producer;
import org.fabric3.api.model.type.component.Property;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.ResourceReference;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.api.model.type.java.ManagementInfo;

public class InjectingComponentType
extends ComponentType {
    private Class<?> implClass;
    private Scope scope;
    private int initLevel;
    private boolean managed;
    private ManagementInfo managementInfo;
    private Constructor<?> constructor;
    private Method initMethod;
    private Method destroyMethod;
    private Map<InjectionSite, Injectable> injectionSites = new HashMap<InjectionSite, Injectable>();
    private Map<ModelObject, InjectionSite> injectionSiteMapping = new HashMap<ModelObject, InjectionSite>();
    private Map<String, Callback> callbacks = new HashMap<String, Callback>();
    private Map<String, AccessibleObject> consumerSignatures = new HashMap<String, AccessibleObject>();

    public InjectingComponentType(Class<?> implClass) {
        this.implClass = implClass;
    }

    public InjectingComponentType() {
    }

    public Class<?> getImplClass() {
        return this.implClass;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setInitLevel(int initLevel) {
        this.initLevel = initLevel;
    }

    public boolean isEagerInit() {
        return this.initLevel > 0;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public ManagementInfo getManagementInfo() {
        return this.managementInfo;
    }

    public void setManagementInfo(ManagementInfo managementInfo) {
        managementInfo.setParent(this);
        this.managementInfo = managementInfo;
    }

    public void add(Reference<ComponentType> reference, InjectionSite injectionSite) {
        super.add(reference);
        Injectable injectable = new Injectable(InjectableType.REFERENCE, reference.getName());
        this.addInjectionSite(injectionSite, injectable);
        this.injectionSiteMapping.put(reference, injectionSite);
    }

    public void add(Producer<ComponentType> producer, InjectionSite injectionSite) {
        super.add(producer);
        Injectable injectable = new Injectable(InjectableType.PRODUCER, producer.getName());
        this.addInjectionSite(injectionSite, injectable);
        this.injectionSiteMapping.put(producer, injectionSite);
    }

    public void add(Consumer<ComponentType> consumer, InjectionSite injectionSite, AccessibleObject object) {
        super.add(consumer);
        Injectable injectable = new Injectable(InjectableType.CONSUMER, consumer.getName());
        this.addInjectionSite(injectionSite, injectable);
        this.injectionSiteMapping.put(consumer, injectionSite);
        this.consumerSignatures.put(consumer.getName(), object);
    }

    public AccessibleObject getConsumerSite(String name) {
        return this.consumerSignatures.get(name);
    }

    public void add(Property property, InjectionSite injectionSite) {
        super.add(property);
        Injectable injectable = new Injectable(InjectableType.PROPERTY, property.getName());
        this.addInjectionSite(injectionSite, injectable);
        this.injectionSiteMapping.put(property, injectionSite);
    }

    public void add(ResourceReference definition, InjectionSite injectionSite) {
        super.add(definition);
        Injectable injectable = new Injectable(InjectableType.RESOURCE, definition.getName());
        this.addInjectionSite(injectionSite, injectable);
        this.injectionSiteMapping.put(definition, injectionSite);
    }

    public void add(Callback definition, InjectionSite injectionSite) {
        definition.setParent(this);
        String name = definition.getName();
        this.callbacks.put(name, definition);
        Injectable injectable = new Injectable(InjectableType.CALLBACK, name);
        this.addInjectionSite(injectionSite, injectable);
        this.injectionSiteMapping.put(definition, injectionSite);
    }

    public Map<String, Callback> getCallbacks() {
        return this.callbacks;
    }

    public void addInjectionSite(InjectionSite site, Injectable source) {
        site.setParent(this);
        source.setParent(this);
        this.injectionSites.put(site, source);
    }

    public Map<InjectionSite, Injectable> getInjectionSites() {
        return this.injectionSites;
    }

    public InjectionSite getInjectionSite(ModelObject object) {
        return this.injectionSiteMapping.get(object);
    }

    public Map<ModelObject, InjectionSite> getInjectionSiteMappings() {
        return this.injectionSiteMapping;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    public Method getInitMethod() {
        return this.initMethod;
    }

    public void setInitMethod(Method initMethod) {
        this.initMethod = initMethod;
    }

    public Method getDestroyMethod() {
        return this.destroyMethod;
    }

    public void setDestroyMethod(Method destroyMethod) {
        this.destroyMethod = destroyMethod;
    }
}

