/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.spi.contribution.ClasspathProcessor;
import org.fabric3.spi.contribution.ClasspathProcessorRegistry;
import org.fabric3.spi.contribution.Contribution;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class ClasspathProcessorRegistryImpl
implements ClasspathProcessorRegistry {
    private List<ClasspathProcessor> processors = new ArrayList<ClasspathProcessor>();

    @Override
    public void register(ClasspathProcessor processor) {
        this.processors.add(processor);
    }

    @Override
    public void unregister(ClasspathProcessor processor) {
        this.processors.remove(processor);
    }

    @Override
    public List<URL> process(Contribution contribution) {
        for (ClasspathProcessor processor : this.processors) {
            if (!processor.canProcess(contribution)) continue;
            return processor.process(contribution);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(contribution.getLocation());
        return urls;
    }
}

