/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionResolver;
import org.fabric3.spi.contribution.MetaDataStore;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DefaultContributionResolver
implements ContributionResolver {
    private MetaDataStore store;

    @Constructor
    public DefaultContributionResolver(@Reference MetaDataStore store) {
        this.store = store;
    }

    @Override
    public URL resolve(URI contributionUri) {
        Contribution contribution = this.store.find(contributionUri);
        if (contribution != null) {
            return contribution.getLocation();
        }
        throw new Fabric3Exception("Contribution not found: " + contributionUri);
    }

    @Override
    public List<URL> resolveAllLocations(URI contributionUri) {
        Contribution contribution = this.store.find(contributionUri);
        if (contribution != null) {
            ArrayList<URL> locations = new ArrayList<URL>();
            locations.add(contribution.getLocation());
            locations.addAll(contribution.getAdditionalLocations());
            return locations;
        }
        throw new Fabric3Exception("Contribution not found: " + contributionUri);
    }
}

