/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.Names;
import org.fabric3.contribution.wire.ContributionWireInstantiatorRegistry;
import org.fabric3.spi.contribution.Capability;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.Reference;

public class MetaDataStoreImpl
implements MetaDataStore {
    private ProcessorRegistry processorRegistry;
    private ContributionWireInstantiatorRegistry instantiatorRegistry;
    private Map<URI, Contribution> cache = new ConcurrentHashMap<URI, Contribution>();

    public MetaDataStoreImpl(ProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
    }

    @Reference
    public void setProcessorRegistry(ProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
    }

    @Reference
    public void setInstantiatorRegistry(ContributionWireInstantiatorRegistry instantiatorRegistry) {
        this.instantiatorRegistry = instantiatorRegistry;
    }

    @Override
    public void store(Contribution contribution) {
        this.cache.put(contribution.getUri(), contribution);
    }

    @Override
    public Contribution find(URI contributionUri) {
        return this.cache.get(contributionUri);
    }

    @Override
    public Set<Contribution> getContributions() {
        return new HashSet<Contribution>(this.cache.values());
    }

    @Override
    public void remove(URI contributionUri) {
        this.cache.remove(contributionUri);
    }

    @Override
    public <S extends Symbol, V> ResourceElement<S, V> find(Class<V> type, S symbol) {
        for (Contribution contribution : this.cache.values()) {
            for (Resource resource : contribution.getResources()) {
                for (ResourceElement<?, ?> element : resource.getResourceElements()) {
                    if (!((Symbol)element.getSymbol()).equals(symbol)) continue;
                    if (ResourceState.UNPROCESSED == resource.getState()) {
                        throw new AssertionError((Object)"Attempt to resolve a resource before it is processed or is in error");
                    }
                    return element;
                }
            }
        }
        return null;
    }

    @Override
    public <S extends Symbol, V> ResourceElement<S, V> find(URI uri, Class<V> type, S symbol) {
        return this.resolve(uri, type, symbol, null);
    }

    @Override
    public <S extends Symbol, V> ResourceElement<S, V> resolve(URI uri, Class<V> type, S symbol, IntrospectionContext context) {
        Contribution contribution = this.find(uri);
        if (contribution == null) {
            String identifier = uri.toString();
            throw new Fabric3Exception("Contribution not found: " + identifier);
        }
        return this.resolve(contribution, type, symbol, context);
    }

    @Override
    public <V> List<ResourceElement<?, V>> resolve(URI uri, Class<V> type) {
        Contribution contribution = this.find(uri);
        if (contribution == null) {
            String identifier = uri.toString();
            throw new Fabric3Exception("Contribution not found: " + identifier);
        }
        ArrayList artifacts = new ArrayList();
        for (Resource resource : contribution.getResources()) {
            for (ResourceElement<?, ?> element : resource.getResourceElements()) {
                Object value = element.getValue();
                if (value == null || !value.getClass().isAssignableFrom(type)) continue;
                artifacts.add(element);
            }
        }
        for (ContributionWire contributionWire : contribution.getWires()) {
            URI exportingUri = contributionWire.getExportContributionUri();
            Contribution exporting = this.find(exportingUri);
            for (Resource resource : exporting.getResources()) {
                for (ResourceElement<?, ?> element : resource.getResourceElements()) {
                    Object value;
                    if (!contributionWire.resolves((Symbol)element.getSymbol()) || (value = element.getValue()) == null || !value.getClass().isAssignableFrom(type)) continue;
                    artifacts.add(element);
                }
            }
        }
        return artifacts;
    }

    @Override
    public List<Contribution> resolve(URI uri, Import imprt) {
        ArrayList<Contribution> resolved = new ArrayList<Contribution>();
        if (!imprt.getResolved().isEmpty()) {
            for (URI exportUri : imprt.getResolved().keySet()) {
                Contribution contribution = this.cache.get(exportUri);
                if (contribution == null) {
                    throw new AssertionError((Object)("Contribution not found: " + contribution));
                }
                resolved.add(contribution);
            }
            return resolved;
        }
        URI location = imprt.getLocation();
        for (Contribution contribution : this.cache.values()) {
            for (Export export : contribution.getManifest().getExports()) {
                if (!export.match(imprt)) continue;
                if (location != null) {
                    if (!location.equals(contribution.getUri())) continue;
                    resolved.add(contribution);
                    imprt.addResolved(contribution.getUri(), export);
                    export.resolve();
                    return resolved;
                }
                if (uri.equals(contribution.getUri())) continue;
                resolved.add(contribution);
                imprt.addResolved(contribution.getUri(), export);
                export.resolve();
            }
        }
        return resolved;
    }

    @Override
    public List<ContributionWire<?, ?>> resolveContributionWires(URI uri, Import imprt) {
        ArrayList wires = new ArrayList();
        for (Map.Entry<URI, Export> entry : imprt.getResolved().entrySet()) {
            ContributionWire<Import, Export> wire = this.instantiatorRegistry.instantiate(imprt, entry.getValue(), uri, entry.getKey());
            wires.add(wire);
        }
        if (wires.isEmpty()) {
            throw new Fabric3Exception(imprt.toString());
        }
        return wires;
    }

    @Override
    public Set<Contribution> resolveDependentContributions(URI uri) {
        HashSet<Contribution> dependents = new HashSet<Contribution>();
        block0: for (Contribution entry : this.cache.values()) {
            List<ContributionWire<?, ?>> contributionWires = entry.getWires();
            for (ContributionWire<?, ?> wire : contributionWires) {
                if (!uri.equals(wire.getExportContributionUri())) continue;
                dependents.add(entry);
                continue block0;
            }
        }
        return dependents;
    }

    @Override
    public List<Contribution> resolveExtensionProviders(String name) {
        ArrayList<Contribution> providers = new ArrayList<Contribution>();
        block0: for (Contribution contribution : this.cache.values()) {
            for (String extend : contribution.getManifest().getExtends()) {
                if (!extend.equals(name)) continue;
                providers.add(contribution);
                continue block0;
            }
        }
        return providers;
    }

    @Override
    public List<Contribution> resolveExtensionPoints(String name) {
        ArrayList<Contribution> extensionPoints = new ArrayList<Contribution>();
        block0: for (Contribution contribution : this.cache.values()) {
            for (String extensionPoint : contribution.getManifest().getExtensionPoints()) {
                if (!extensionPoint.equals(name)) continue;
                extensionPoints.add(contribution);
                continue block0;
            }
        }
        return extensionPoints;
    }

    @Override
    public Set<Contribution> resolveCapabilities(Contribution contribution) {
        HashSet<Contribution> extensions = new HashSet<Contribution>();
        return this.resolveCapabilities(contribution, extensions);
    }

    @Override
    public Set<Contribution> resolveCapability(String capability) {
        HashSet<Contribution> extensions = new HashSet<Contribution>();
        for (Contribution entry : this.cache.values()) {
            Capability key = new Capability(capability);
            if (!entry.getManifest().getProvidedCapabilities().contains(key) || extensions.contains(entry)) continue;
            extensions.add(entry);
            this.resolveCapabilities(entry, extensions);
        }
        return extensions;
    }

    private <S extends Symbol, V> ResourceElement<S, V> resolve(Contribution contribution, Class<V> type, S symbol, IntrospectionContext context) {
        ResourceElement<S, V> element;
        for (ContributionWire<?, ?> wire : contribution.getWires()) {
            if (!wire.resolves(symbol)) continue;
            URI resolvedUri = wire.getExportContributionUri();
            Contribution resolved = this.cache.get(resolvedUri);
            if (resolved == null) {
                throw new AssertionError((Object)("Dependent contribution not found: " + resolvedUri));
            }
            element = this.resolve(resolved, type, symbol, context);
            if (element == null) continue;
            return element;
        }
        element = this.resolveInternal(contribution, type, symbol, context);
        if (element != null) {
            return element;
        }
        return null;
    }

    private Set<Contribution> resolveCapabilities(Contribution contribution, Set<Contribution> extensions) {
        Set<Capability> required = contribution.getManifest().getRequiredCapabilities();
        for (Capability capability : required) {
            this.cache.values().stream().filter(entry -> entry.getManifest().getProvidedCapabilities().contains(capability) && !extensions.contains(entry)).forEach(entry -> {
                extensions.add((Contribution)entry);
                this.resolveCapabilities((Contribution)entry, extensions);
            });
        }
        for (ContributionWire contributionWire : contribution.getWires()) {
            Contribution imported = this.cache.get(contributionWire.getExportContributionUri());
            if (imported.getManifest().isExtension() && !extensions.contains(imported) && !imported.getUri().equals(Names.HOST_CONTRIBUTION) && !imported.getUri().equals(Names.BOOT_CONTRIBUTION)) {
                extensions.add(imported);
            }
            this.resolveCapabilities(imported, extensions);
        }
        for (URI uRI : contribution.getResolvedExtensionProviders()) {
            Contribution provider = this.cache.get(uRI);
            if (extensions.contains(provider)) continue;
            extensions.add(provider);
        }
        return extensions;
    }

    private <S extends Symbol, V> ResourceElement<S, V> resolveInternal(Contribution contribution, Class<V> type, S symbol, IntrospectionContext context) {
        for (Resource resource : contribution.getResources()) {
            for (ResourceElement<?, ?> element : resource.getResourceElements()) {
                Object val;
                if (!((Symbol)element.getSymbol()).equals(symbol)) continue;
                if (ResourceState.UNPROCESSED == resource.getState() && context == null) {
                    String identifier = resource.getSource().getSystemId();
                    throw new AssertionError((Object)("Resource not resolved: " + identifier));
                }
                if (ResourceState.UNPROCESSED == resource.getState() && context != null) {
                    this.processorRegistry.processResource(resource, context);
                }
                if (!type.isInstance(val = element.getValue())) {
                    throw new IllegalArgumentException("Invalid type for symbol. Expected: " + type + " was: " + val);
                }
                return element;
            }
        }
        return null;
    }
}

