/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.contribution.archive.AbstractContributionProcessor;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.archive.ArchiveContributionHandler;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.Reference;

public class ArchiveContributionProcessor
extends AbstractContributionProcessor {
    private List<ArchiveContributionHandler> handlers;

    @Reference
    public void setHandlers(List<ArchiveContributionHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public boolean canProcess(Contribution contribution) {
        for (ArchiveContributionHandler handler : this.handlers) {
            if (!handler.canProcess(contribution)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processManifest(Contribution contribution, IntrospectionContext context) {
        ArchiveContributionHandler handler = this.getHandler(contribution);
        handler.processManifest(contribution, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(Contribution contribution, IntrospectionContext context) {
        ArchiveContributionHandler handler = this.getHandler(contribution);
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = context.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            handler.iterateArtifacts(contribution, resource -> this.registry.indexResource((Resource)resource, context), context);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Contribution contribution, IntrospectionContext context) {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = context.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            ArrayList<Resource> copy = new ArrayList<Resource>(contribution.getResources());
            copy.stream().filter(resource -> ResourceState.UNPROCESSED == resource.getState()).forEach(resource -> this.registry.processResource((Resource)resource, context));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    private ArchiveContributionHandler getHandler(Contribution contribution) {
        for (ArchiveContributionHandler handler : this.handlers) {
            if (!handler.canProcess(contribution)) continue;
            return handler;
        }
        throw new Fabric3Exception("Contribution type not supported: " + contribution.getUri());
    }
}

